/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public class AllLabelsPacket
extends PacketCodec {
    public static final CustomPacketPayload.Type<AllLabelsPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"all_labels"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AllLabelsPacket> CODEC = AllLabelsPacket.getCodec(AllLabelsPacket::new);
    @CodecField
    private Map<Integer, String> labels;

    public AllLabelsPacket() {
        super(ID);
    }

    public AllLabelsPacket(Map<Integer, String> labels) {
        super(ID);
        this.labels = labels;
    }

    public boolean isAsync() {
        return false;
    }

    public void actionClient(Level world, Player player) {
        if (this.labels != null) {
            LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().clear();
            for (Map.Entry<Integer, String> entry : this.labels.entrySet()) {
                LabelsWorldStorage.Access.getInstance(IntegratedDynamics._instance).get().putUnsafe(entry.getKey(), entry.getValue());
            }
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

