/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract;

import com.example.soundattract.DynamicScanCooldownManager;
import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.SoundTracker;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.BlockBreakerManager;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.ai.MobGroupManager;
import com.example.soundattract.ai.RaidManager;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.worker.WorkerScheduler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="soundattract", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundAttractionEvents {
    private static final Map<Mob, List<GoalDefinition>> PENDING_GOAL_ADDITIONS = new ConcurrentHashMap<Mob, List<GoalDefinition>>();
    private static long serverTickCounter = 0L;
    private static boolean initialDelayHasPassed = false;
    private static long lastMobCountUpdateTime_ServerTick = -1L;
    private static int cachedAttractedMobCount_ServerTick = 0;
    private static Set<EntityType<?>> CACHED_ATTRACTED_ENTITY_TYPES = null;
    private static List<String> lastKnownAttractedEntitiesConfig_Copy = null;
    private static Set<EntityType<?>> CACHED_BLACKLISTED_ENTITY_TYPES = null;
    private static List<String> lastKnownBlacklistConfig_Copy = null;

    private static void scheduleAddGoal(Mob mob, int priority, Goal goal) {
        PENDING_GOAL_ADDITIONS.computeIfAbsent(mob, k -> new ArrayList()).add(new GoalDefinition(priority, goal));
    }

    public static Set<EntityType<?>> getCachedAttractedEntityTypes() {
        List currentConfigListFromGetter = (List)SoundAttractConfig.COMMON.attractedEntities.get();
        ArrayList<String> currentConfigListMutableCopy = new ArrayList<String>(currentConfigListFromGetter);
        if (CACHED_ATTRACTED_ENTITY_TYPES == null || lastKnownAttractedEntitiesConfig_Copy == null || !lastKnownAttractedEntitiesConfig_Copy.equals(currentConfigListMutableCopy)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && CACHED_ATTRACTED_ENTITY_TYPES != null) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Attracted entities config changed, rebuilding EntityType cache.");
            }
            CACHED_ATTRACTED_ENTITY_TYPES = currentConfigListFromGetter.stream().map(idStr -> {
                try {
                    return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)idStr));
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Invalid ResourceLocation for attracted entity type in config: {}", idStr, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            lastKnownAttractedEntitiesConfig_Copy = currentConfigListMutableCopy;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                String resultingTypes = CACHED_ATTRACTED_ENTITY_TYPES.stream().map(et -> ForgeRegistries.ENTITY_TYPES.getKey(et).toString()).collect(Collectors.joining(", "));
                SoundAttractMod.LOGGER.info("[DIAGNOSTIC] Final attracted EntityType cache contains: [{}]", (Object)resultingTypes);
            }
        }
        return CACHED_ATTRACTED_ENTITY_TYPES;
    }

    public static Set<EntityType<?>> getCachedBlacklistedEntityTypes() {
        List currentConfigListFromGetter = (List)SoundAttractConfig.COMMON.mobBlacklist.get();
        ArrayList<String> currentConfigListMutableCopy = new ArrayList<String>(currentConfigListFromGetter);
        if (CACHED_BLACKLISTED_ENTITY_TYPES == null || lastKnownBlacklistConfig_Copy == null || !lastKnownBlacklistConfig_Copy.equals(currentConfigListMutableCopy)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && CACHED_BLACKLISTED_ENTITY_TYPES != null) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Mob blacklist config changed, rebuilding EntityType cache.");
            }
            CACHED_BLACKLISTED_ENTITY_TYPES = currentConfigListFromGetter.stream().map(idStr -> {
                try {
                    return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)idStr));
                }
                catch (Exception e) {
                    SoundAttractMod.LOGGER.warn("[SoundAttractionEvents] Invalid ResourceLocation for blacklisted entity type in config: {}", idStr, (Object)e);
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            lastKnownBlacklistConfig_Copy = currentConfigListMutableCopy;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                String resultingTypes = CACHED_BLACKLISTED_ENTITY_TYPES.stream().map(et -> ForgeRegistries.ENTITY_TYPES.getKey(et).toString()).collect(Collectors.joining(", "));
                SoundAttractMod.LOGGER.info("[DIAGNOSTIC] Final blacklisted EntityType cache contains: [{}]", (Object)resultingTypes);
            }
        }
        return CACHED_BLACKLISTED_ENTITY_TYPES;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            int delay;
            if (!initialDelayHasPassed && ++serverTickCounter >= (long)(delay = ((Integer)SoundAttractConfig.COMMON.initialGroupComputationDelay.get()).intValue())) {
                initialDelayHasPassed = true;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Initial group computation delay of {} ticks has passed. Enabling group updates.", (Object)delay);
                }
            }
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            block19: {
                if (!initialDelayHasPassed) {
                    return;
                }
                if (ServerLifecycleHooks.getCurrentServer() == null || ServerLifecycleHooks.getCurrentServer().m_129783_() == null) {
                    return;
                }
                ServerLevel serverLevel = ServerLifecycleHooks.getCurrentServer().m_129783_();
                long currentTime = serverLevel.m_46467_();
                int mobCountUpdateInterval = (Integer)SoundAttractConfig.COMMON.groupUpdateInterval.get();
                if (currentTime - lastMobCountUpdateTime_ServerTick >= (long)(mobCountUpdateInterval = Math.max(20, mobCountUpdateInterval)) || lastMobCountUpdateTime_ServerTick == -1L) {
                    int currentMobCount = 0;
                    HashSet countedMobsInTick = new HashSet();
                    Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
                    if (!attractedEntityTypes.isEmpty()) {
                        for (ServerPlayer player : serverLevel.m_6907_()) {
                            int simDistanceBlocks = player.f_8924_.m_6846_().m_11312_() * 16;
                            AABB playerSimArea = player.m_20191_().m_82400_((double)simDistanceBlocks);
                            List mobsNearPlayer = serverLevel.m_45976_(Mob.class, playerSimArea);
                            for (Mob mob : mobsNearPlayer) {
                                if (!mob.m_6084_() || mob.m_213877_() || !attractedEntityTypes.contains(mob.m_6095_()) || !countedMobsInTick.add(mob)) continue;
                                ++currentMobCount;
                            }
                        }
                    }
                    cachedAttractedMobCount_ServerTick = currentMobCount;
                    lastMobCountUpdateTime_ServerTick = currentTime;
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Updated attracted mob count for DynamicScanCooldownManager: {}", (Object)cachedAttractedMobCount_ServerTick);
                    }
                }
                int mobCountForCooldownManager = cachedAttractedMobCount_ServerTick;
                DynamicScanCooldownManager.update(currentTime, mobCountForCooldownManager);
                SoundTracker.tick();
                BlockBreakerManager.processPendingActions();
                try {
                    List<WorkerScheduler.GroupComputeResult> results = WorkerScheduler.drainGroupResults();
                    if (!results.isEmpty()) {
                        for (WorkerScheduler.GroupComputeResult r : results) {
                            ServerLevel level;
                            if (r.dimension() == null || (level = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)r.dimension()))) == null) continue;
                            MobGroupManager.applyGroupResult(level, r);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block19;
                    SoundAttractMod.LOGGER.error("[SoundAttractionEvents] Applying group results failed", t);
                }
            }
            if (!PENDING_GOAL_ADDITIONS.isEmpty()) {
                Iterator<Map.Entry<Mob, List<GoalDefinition>>> iterator = PENDING_GOAL_ADDITIONS.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Mob, List<GoalDefinition>> entry = iterator.next();
                    Mob mob = entry.getKey();
                    List<GoalDefinition> goalsToAdd = entry.getValue();
                    if (mob.m_6084_() && mob.m_9236_() != null && !mob.m_213877_()) {
                        for (GoalDefinition def : goalsToAdd) {
                            boolean goalExists = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> def.goalClass.isInstance(wrappedGoal.m_26015_()));
                            if (goalExists) continue;
                            mob.f_21345_.m_25352_(def.priority, def.goalInstance);
                            if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Added goal {} to mob {}", (Object)def.goalClass.getSimpleName(), (Object)mob.m_7755_().getString());
                        }
                    }
                    iterator.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_() && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (initialDelayHasPassed) {
                MobGroupManager.updateGroups(serverLevel);
                RaidManager.tick(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onMobJoinLevel(EntityJoinLevelEvent event) {
        Level level;
        boolean hasMatchingprofile;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Set<EntityType<?>> blacklistedEntityTypes = SoundAttractionEvents.getCachedBlacklistedEntityTypes();
        if (blacklistedEntityTypes.contains(mob.m_6095_())) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Mob {} is on the blacklist, ignoring.", (Object)EntityType.m_20613_((EntityType)mob.m_6095_()));
            }
            return;
        }
        Set<EntityType<?>> attractedEntityTypes = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean isAttractedByType = attractedEntityTypes.contains(mob.m_6095_());
        boolean bl = hasMatchingprofile = SoundAttractConfig.getMatchingProfile(mob) != null;
        if (!isAttractedByType && !hasMatchingprofile) {
            return;
        }
        double moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        if (((Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get()).booleanValue()) {
            SoundAttractionEvents.scheduleAddGoal(mob, 3, new LeaderAttractionGoal(mob, moveSpeed));
            SoundAttractionEvents.scheduleAddGoal(mob, 1, new FollowerEdgeRelayGoal(mob, moveSpeed));
        } else {
            SoundAttractionEvents.scheduleAddGoal(mob, 3, new AttractionGoal(mob, moveSpeed));
        }
        SoundAttractionEvents.scheduleAddGoal(mob, 4, new FollowLeaderGoal(mob, moveSpeed));
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[SoundAttractionEvents] Scheduled goals for mob {} of type {}", (Object)mob.m_7755_().getString(), (Object)EntityType.m_20613_((EntityType)mob.m_6095_()));
        }
        if ((level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (initialDelayHasPassed) {
                MobGroupManager.updateGroups(serverLevel);
            }
        }
    }

    private static class GoalDefinition {
        final int priority;
        final Goal goalInstance;
        final Class<? extends Goal> goalClass;

        GoalDefinition(int priority, Goal goalInstance) {
            this.priority = priority;
            this.goalInstance = goalInstance;
            this.goalClass = goalInstance.getClass();
        }
    }
}

