/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.EnhancedAICompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;

public class BlockBreakerPosGoal
extends Goal {
    private final Mob miner;
    private final BlockPos destinationPos;
    private final double reachDistance;
    private final double timeToBreakMultiplier;
    private final List<BlockPos> targetBlocks = new ArrayList<BlockPos>();
    private int tickToBreak = 0;
    private int breakingTick = 0;
    private BlockState blockState = null;
    private int prevBreakProgress = 0;
    private final boolean toolOnly;
    private final boolean properToolOnly;
    private final boolean properToolRequired;

    public BlockBreakerPosGoal(Mob miner, BlockPos destination, double timeToBreakMultiplier, boolean toolOnly, boolean properToolOnly, boolean properToolRequired) {
        this.miner = miner;
        this.destinationPos = destination;
        this.reachDistance = 4.9;
        this.timeToBreakMultiplier = timeToBreakMultiplier;
        this.toolOnly = toolOnly;
        this.properToolOnly = properToolOnly;
        this.properToolRequired = properToolRequired;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.miner.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: mobGriefing is false.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        if (this.destinationPos == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: destinationPos is null.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        if (this.toolOnly && !(this.miner.m_21206_().m_41720_() instanceof DiggerItem)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: toolOnly is true, but no DiggerItem in offhand.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        this.fillTargetBlocks();
        if (this.targetBlocks.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse FAILED for {}: fillTargetBlocks() found no blocks to break.", (Object)this.miner.m_7755_().getString());
            }
            return false;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] canUse PASSED for {}. Target block: {}.", (Object)this.miner.m_7755_().getString(), (Object)this.targetBlocks.get(0));
        }
        return true;
    }

    public boolean m_8045_() {
        if (this.targetBlocks.isEmpty() || this.destinationPos == null) {
            return false;
        }
        if (this.properToolOnly && this.blockState != null && !this.canBreakBlock()) {
            return false;
        }
        if (this.miner.m_20183_().m_123331_((Vec3i)this.destinationPos) < 4.0) {
            return false;
        }
        return !this.miner.m_9236_().m_8055_(this.targetBlocks.get(0)).m_60795_();
    }

    public void m_8056_() {
        if (!this.targetBlocks.isEmpty()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] STARTING for {}. Beginning to break {}.", (Object)this.miner.m_7755_().getString(), (Object)this.targetBlocks.get(0));
            }
            this.initBlockBreak();
            this.miner.m_21561_(true);
        } else if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] Attempted to START for {}, but targetBlocks was empty.", (Object)this.miner.m_7755_().getString());
        }
    }

    public void m_8041_() {
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] STOPPING for {}.", (Object)this.miner.m_7755_().getString());
        }
        if (!this.targetBlocks.isEmpty()) {
            this.miner.m_9236_().m_6801_(this.miner.m_19879_(), this.targetBlocks.get(0), -1);
            this.targetBlocks.clear();
        }
        this.tickToBreak = 0;
        this.breakingTick = 0;
        this.blockState = null;
        this.prevBreakProgress = 0;
        this.miner.m_21561_(false);
    }

    public void m_8037_() {
        Level level;
        if (this.targetBlocks.isEmpty()) {
            return;
        }
        if (this.properToolOnly && this.blockState != null && !this.canBreakBlock()) {
            return;
        }
        BlockPos pos = this.targetBlocks.get(0);
        ++this.breakingTick;
        this.miner.m_21563_().m_24946_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (this.prevBreakProgress != (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f)) {
            this.prevBreakProgress = (int)((float)this.breakingTick / (float)this.tickToBreak * 10.0f);
            this.miner.m_9236_().m_6801_(this.miner.m_19879_(), pos, this.prevBreakProgress);
        }
        if (this.breakingTick % 6 == 0) {
            this.miner.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.breakingTick % 4 == 0) {
            SoundType soundType = this.blockState.getSoundType((LevelReader)this.miner.m_9236_(), pos, (Entity)this.miner);
            this.miner.m_9236_().m_5594_(null, pos, soundType.m_56778_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 8.0f, soundType.m_56774_() * 0.5f);
        }
        if (this.breakingTick >= this.tickToBreak && (level = this.miner.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this.miner, (BlockPos)this.targetBlocks.get(0), (BlockState)this.blockState) && this.miner.m_9236_().m_46953_(pos, false, (Entity)this.miner)) {
                BlockEntity blockentity = this.blockState.m_155947_() ? this.miner.m_9236_().m_7702_(pos) : null;
                LootParams.Builder lootparams$builder = new LootParams.Builder(level2).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)this.miner.m_21206_()).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.miner);
                this.blockState.m_222967_(level2, pos, this.miner.m_21206_(), false);
                this.blockState.m_287290_(lootparams$builder).forEach(itemStack -> level2.m_7967_((Entity)new ItemEntity((Level)level2, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), itemStack)));
            }
            this.miner.m_9236_().m_6801_(this.miner.m_19879_(), pos, -1);
            this.targetBlocks.remove(0);
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.miner.m_9236_().m_8055_(this.targetBlocks.get(0));
        this.tickToBreak = this.computeTickToBreak();
        this.breakingTick = 0;
    }

    private void fillTargetBlocks() {
        this.targetBlocks.clear();
        if (this.destinationPos == null) {
            return;
        }
        Vec3 destinationVec = Vec3.m_82512_((Vec3i)this.destinationPos);
        int mobHeight = Mth.m_14167_((float)this.miner.m_20206_());
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] fillTargetBlocks for {}: Raycasting from mob eyes to {}.", (Object)this.miner.m_7755_().getString(), (Object)destinationVec);
        }
        for (int i = 0; i < mobHeight; ++i) {
            Vec3 rayStart = this.miner.m_146892_().m_82520_(0.0, (double)i, 0.0);
            BlockHitResult rayTraceResult = this.miner.m_9236_().m_45547_(new ClipContext(rayStart, destinationVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.miner));
            if (rayTraceResult.m_6662_() == HitResult.Type.MISS) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> Raycast MISS. No blocks in the way.");
                continue;
            }
            BlockPos hitPos = rayTraceResult.m_82425_();
            BlockState state = this.miner.m_9236_().m_8055_(hitPos);
            if (this.targetBlocks.contains(hitPos)) continue;
            if (hitPos.m_123342_() > EnhancedAICompat.getMaxY()) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} at Y={} is above maxY of {}.", new Object[]{this.miner.m_7755_().getString(), state.m_60734_().m_49954_().getString(), hitPos.m_123342_(), EnhancedAICompat.getMaxY()});
                continue;
            }
            double distance = this.miner.m_20238_(rayTraceResult.m_82450_());
            if (distance > this.reachDistance * this.reachDistance) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is too far away (distSqr {} > {}).", new Object[]{this.miner.m_7755_().getString(), state.m_60734_().m_49954_().getString(), distance, this.reachDistance * this.reachDistance});
                continue;
            }
            if (state.m_155947_() && EnhancedAICompat.shouldBlacklistTileEntities()) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is a blacklisted Tile Entity.", (Object)this.miner.m_7755_().getString(), (Object)state.m_60734_().m_49954_().getString());
                continue;
            }
            if (state.m_60800_((BlockGetter)this.miner.m_9236_(), hitPos) == -1.0f) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is unbreakable (destroy speed -1).", (Object)this.miner.m_7755_().getString(), (Object)state.m_60734_().m_49954_().getString());
                continue;
            }
            if (!EnhancedAICompat.isBlacklistAsWhitelist() && state.m_204336_(EnhancedAICompat.getBlockBlacklistTag()) || EnhancedAICompat.isBlacklistAsWhitelist() && !state.m_204336_(EnhancedAICompat.getBlockBlacklistTag())) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) continue;
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> FAILED check for {}: Block {} is in the blacklist/not in whitelist.", (Object)this.miner.m_7755_().getString(), (Object)state.m_60734_().m_49954_().getString());
                continue;
            }
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[BlockBreakerPosGoal] -> SUCCESS: Found valid block to break: {} at {}.", (Object)state.m_60734_().m_49954_().getString(), (Object)hitPos);
            }
            this.targetBlocks.add(hitPos);
        }
        Collections.reverse(this.targetBlocks);
    }

    public boolean m_183429_() {
        return true;
    }

    private int computeTickToBreak() {
        int canHarvestBlock;
        int n = canHarvestBlock = this.canHarvestBlock() ? 30 : 100;
        if (this.blockState.m_60800_((BlockGetter)this.miner.m_9236_(), this.targetBlocks.get(0)) == 0.0f) {
            return 1;
        }
        double diggingSpeed = this.getDigSpeed() / this.blockState.m_60800_((BlockGetter)this.miner.m_9236_(), this.targetBlocks.get(0)) / (float)canHarvestBlock;
        return Mth.m_14165_((double)(1.0 / diggingSpeed * this.timeToBreakMultiplier));
    }

    private float getDigSpeed() {
        float digSpeed = this.miner.m_21206_().m_41691_(this.blockState);
        if (digSpeed > 1.0f) {
            int efficiencyLevel = EnchantmentHelper.m_44926_((LivingEntity)this.miner);
            ItemStack itemstack = this.miner.m_21206_();
            if (efficiencyLevel > 0 && !itemstack.m_41619_()) {
                digSpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)this.miner)) {
            digSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)this.miner) + 1) * 0.2f;
        }
        if (this.miner.m_21023_(MobEffects.f_19599_)) {
            float miningFatigueAmplifier = switch (this.miner.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            digSpeed *= miningFatigueAmplifier;
        }
        if (this.miner.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)this.miner)) {
            digSpeed /= 5.0f;
        }
        return digSpeed;
    }

    private boolean canBreakBlock() {
        if (!this.blockState.m_60834_() || !this.properToolRequired) {
            return true;
        }
        ItemStack stack = this.miner.m_21206_();
        return !stack.m_41619_() && stack.m_41735_(this.blockState);
    }

    private boolean canHarvestBlock() {
        if (!this.blockState.m_60834_()) {
            return true;
        }
        ItemStack stack = this.miner.m_21206_();
        return !stack.m_41619_() && stack.m_41735_(this.blockState);
    }
}

