/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.config;

import net.minecraft.resources.ResourceLocation;

public class SoundOverride {
    private final ResourceLocation soundId;
    private final double range;
    private final double weight;

    public SoundOverride(ResourceLocation soundId, double range, double weight) {
        if (soundId == null) {
            throw new IllegalArgumentException("SoundOverride soundId cannot be null");
        }
        this.soundId = soundId;
        this.range = range;
        this.weight = weight;
    }

    public ResourceLocation getSoundId() {
        return this.soundId;
    }

    public double getRange() {
        return this.range;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        return "SoundOverride{soundId=" + this.soundId + ", range=" + this.range + ", weight=" + this.weight + "}";
    }

    public static SoundOverride parse(String entry) {
        double weight;
        double range;
        String weightStr;
        String rangeStr;
        ResourceLocation soundId;
        if (entry == null || entry.trim().isEmpty()) {
            throw new IllegalArgumentException("SoundOverride entry cannot be null or empty.");
        }
        String[] parts = entry.trim().split(":", -1);
        if (parts.length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("Malformed SoundOverride entry '" + entry + "'. Expected 3 or 4 parts separated by ':', got " + parts.length + " parts. Format: '[namespace:]path:range:weight'");
        }
        if (parts.length == 4) {
            if (parts[0].trim().isEmpty() || parts[1].trim().isEmpty()) {
                throw new IllegalArgumentException("Malformed SoundOverride entry '" + entry + "'. Namespace or path part is empty when 4 parts are provided.");
            }
            soundId = ResourceLocation.m_135820_((String)(parts[0].trim() + ":" + parts[1].trim()));
            rangeStr = parts[2].trim();
            weightStr = parts[3].trim();
        } else {
            if (parts[0].trim().isEmpty()) {
                throw new IllegalArgumentException("Malformed SoundOverride entry '" + entry + "'. Path part is empty when 3 parts are provided.");
            }
            soundId = ResourceLocation.m_135820_((String)("minecraft:" + parts[0].trim()));
            rangeStr = parts[1].trim();
            weightStr = parts[2].trim();
        }
        if (soundId == null) {
            throw new IllegalArgumentException("Invalid sound ID format in SoundOverride entry '" + entry + "' from parts '" + (parts.length == 4 ? parts[0] + ":" + parts[1] : "minecraft:" + parts[0]) + "'.");
        }
        try {
            if (rangeStr.isEmpty()) {
                throw new NumberFormatException("Range string is empty");
            }
            range = Double.parseDouble(rangeStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid range value '" + rangeStr + "' in SoundOverride entry '" + entry + "'", e);
        }
        try {
            if (weightStr.isEmpty()) {
                throw new NumberFormatException("Weight string is empty");
            }
            weight = Double.parseDouble(weightStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid weight value '" + weightStr + "' in SoundOverride entry '" + entry + "'", e);
        }
        return new SoundOverride(soundId, range, weight);
    }
}

