/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.storiesofbelow.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.storiesofbelow.StoriesOfBelowMod;
import net.mcreator.storiesofbelow.procedures.EncoderAProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderBProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderBackProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderCProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderDProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderEProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderFProcedure;
import net.mcreator.storiesofbelow.procedures.EncoderGProcedure;
import net.mcreator.storiesofbelow.world.inventory.EncoderGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EncoderGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public EncoderGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public EncoderGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(EncoderGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(EncoderGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EncoderGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = EncoderGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            EncoderCProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            EncoderDProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            EncoderEProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            EncoderFProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            EncoderGProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            EncoderAProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            EncoderBProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            EncoderBackProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        StoriesOfBelowMod.addNetworkMessage(EncoderGUIButtonMessage.class, EncoderGUIButtonMessage::buffer, EncoderGUIButtonMessage::new, EncoderGUIButtonMessage::handler);
    }
}

