/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.KoboldArmorModel;
import net.salju.kobolds.client.model.RascalModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;
import net.salju.kobolds.client.renderer.layers.KoboldEyesLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsClient;

public class KoboldRascalRenderer
extends MobRenderer<AbstractKoboldEntity, AbstractKoboldState, RascalModel<AbstractKoboldState>> {
    public KoboldRascalRenderer(EntityRendererProvider.Context context) {
        super(context, new RascalModel(context.bakeLayer(KoboldsClient.KOBOLD_RASCAL)), 0.36f);
        this.addLayer((RenderLayer)new KoboldEyesLayer(this));
        this.addLayer((RenderLayer)new ItemInHandLayer<AbstractKoboldState, RascalModel<AbstractKoboldState>>(this, (RenderLayerParent)this){

            public void render(PoseStack pose, MultiBufferSource buffer, int i, AbstractKoboldState kobold, float f1, float f2) {
                if (kobold.isAggressive) {
                    super.render(pose, buffer, i, (ArmedEntityRenderState)kobold, f1, f2);
                }
            }
        });
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_INNER)), (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_OUTER)), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(AbstractKoboldState kobold) {
        return kobold.texture;
    }

    public AbstractKoboldState createRenderState() {
        return new AbstractKoboldState();
    }

    public void extractRenderState(AbstractKoboldEntity kobold, AbstractKoboldState state, float f1) {
        super.extractRenderState((LivingEntity)kobold, (LivingEntityRenderState)state, f1);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)kobold, (HumanoidRenderState)state, (float)f1, (ItemModelResolver)this.itemModelResolver);
        state.texture = ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/kobolds/rascal.png");
        state.isAggressive = kobold.isAggressive();
        state.isDiamond = kobold.isDiamond();
        state.isLeftHanded = kobold.isLeftHanded();
        state.rightStack = kobold.getItemHeldByArm(HumanoidArm.RIGHT);
        state.leftStack = kobold.getItemHeldByArm(HumanoidArm.LEFT);
    }

    public void render(AbstractKoboldState kobold, PoseStack stack, MultiBufferSource buffer, int i) {
        stack.pushPose();
        stack.translate(-0.025, 0.0, 0.0);
        float scale = 0.875f;
        stack.scale(scale, scale, scale);
        super.render((LivingEntityRenderState)kobold, stack, buffer, i);
        stack.popPose();
    }
}

