/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.init;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.SkullBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.salju.kobolds.block.KoboldSkull;
import net.salju.kobolds.block.KoboldWitherSkull;
import net.salju.kobolds.client.model.KoboldArmorModel;
import net.salju.kobolds.client.model.KoboldChildModel;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.model.KoboldSkullModel;
import net.salju.kobolds.client.model.RascalModel;
import net.salju.kobolds.client.model.SkeleboldModel;
import net.salju.kobolds.client.renderer.KoboldCaptainRenderer;
import net.salju.kobolds.client.renderer.KoboldChildRenderer;
import net.salju.kobolds.client.renderer.KoboldEnchanterRenderer;
import net.salju.kobolds.client.renderer.KoboldEngineerRenderer;
import net.salju.kobolds.client.renderer.KoboldPirateRenderer;
import net.salju.kobolds.client.renderer.KoboldRascalRenderer;
import net.salju.kobolds.client.renderer.KoboldRenderer;
import net.salju.kobolds.client.renderer.KoboldSkeletonRenderer;
import net.salju.kobolds.client.renderer.KoboldWarriorRenderer;
import net.salju.kobolds.client.renderer.KoboldWitherRenderer;
import net.salju.kobolds.client.renderer.KoboldZombieRenderer;
import net.salju.kobolds.init.KoboldsMobs;

@EventBusSubscriber(value={Dist.CLIENT})
public class KoboldsClient {
    public static final ModelLayerLocation KOBOLD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold"), "main");
    public static final ModelLayerLocation KOBOLD_RASCAL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold_rascal"), "main");
    public static final ModelLayerLocation KOBOLD_CHILD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold_child"), "main");
    public static final ModelLayerLocation KOBOLD_ARMOR_INNER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold_armor_inner"), "main");
    public static final ModelLayerLocation KOBOLD_ARMOR_OUTER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold_armor_outer"), "main");
    public static final ModelLayerLocation KOBOLD_SKULL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold_skull"), "main");
    public static final ModelLayerLocation KOBOLD_WITHER_SKULL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"kobold_wither_skull"), "main");
    public static final ModelLayerLocation SKELEBOLD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"skelebold"), "main");
    public static final ModelLayerLocation WITHERBOLD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"witherbold"), "main");
    public static final ModelLayerLocation ZOMBOLD = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"zombold"), "main");

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(KOBOLD_ARMOR_INNER, KoboldArmorModel::createInnerArmorLayer);
        event.registerLayerDefinition(KOBOLD_ARMOR_OUTER, KoboldArmorModel::createOuterArmorLayer);
        event.registerLayerDefinition(KOBOLD, KoboldModel::createBodyLayer);
        event.registerLayerDefinition(KOBOLD_RASCAL, RascalModel::createBodyLayer);
        event.registerLayerDefinition(KOBOLD_CHILD, KoboldChildModel::createBodyLayer);
        event.registerLayerDefinition(ZOMBOLD, KoboldModel::createBodyLayer);
        event.registerLayerDefinition(SKELEBOLD, SkeleboldModel::createBodyLayer);
        event.registerLayerDefinition(WITHERBOLD, SkeleboldModel::createBodyLayer);
        event.registerLayerDefinition(KOBOLD_WITHER_SKULL, KoboldSkullModel::createBodyLayer);
        event.registerLayerDefinition(KOBOLD_SKULL, KoboldSkullModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD.get(), KoboldRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), KoboldWarriorRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_ENCHANTER.get(), KoboldEnchanterRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_ENGINEER.get(), KoboldEngineerRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_PIRATE.get(), KoboldPirateRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_CAPTAIN.get(), KoboldCaptainRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_CHILD.get(), KoboldChildRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get(), KoboldZombieRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_SKELETON.get(), KoboldSkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.KOBOLD_RASCAL.get(), KoboldRascalRenderer::new);
        event.registerEntityRenderer((EntityType)KoboldsMobs.WITHERBOLD.get(), KoboldWitherRenderer::new);
    }

    @SubscribeEvent
    public static void registerSkullRenderers(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)KoboldSkull.Types.SKELEBOLD, KOBOLD_SKULL);
        event.registerSkullModel((SkullBlock.Type)KoboldWitherSkull.Types.WITHERBOLD, KOBOLD_WITHER_SKULL);
    }

    @SubscribeEvent
    public static void clientSetupEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> SkullBlockRenderer.SKIN_BY_TYPE.put(KoboldSkull.Types.SKELEBOLD, ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/undead/skeleton.png")));
        event.enqueueWork(() -> SkullBlockRenderer.SKIN_BY_TYPE.put(KoboldWitherSkull.Types.WITHERBOLD, ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/undead/skeleton_wither.png")));
    }
}

