/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.AbstractKoboldState;

public class SkeleboldModel<T extends AbstractKoboldState>
extends HumanoidModel<T> {
    public SkeleboldModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = KoboldModel.createMesh(CubeDeformation.NONE, 0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(46, 16).addBox(-2.01f, -0.85f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)5.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(33, 16).addBox(0.01f, -0.85f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)5.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(13, 31).addBox(-1.0f, -0.01f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)14.0f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 31).addBox(-1.0f, -0.01f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)14.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 15).addBox(-3.0f, 0.0f, -2.0f, 6.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 15).addBox(-0.5f, 6.0f, -4.0f, 1.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T kobold) {
        this.rightArm.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 2.0f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f)) * 2.0f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed * 0.5f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = 0.0f;
        this.leftLeg.xRot = 0.0f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.body.xRot = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f)) * 1.4f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed;
        this.leftLeg.xRot = Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((AbstractKoboldState)((Object)kobold)).walkAnimationSpeed;
        this.head.yRot = ((AbstractKoboldState)((Object)kobold)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((AbstractKoboldState)((Object)kobold)).xRot * ((float)Math.PI / 180);
        this.rightArm.zRot += Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).ageInTicks * 0.04f)) * 0.04f + 0.04f;
        this.leftArm.zRot -= Mth.cos((float)(((AbstractKoboldState)((Object)kobold)).ageInTicks * 0.04f)) * 0.04f + 0.04f;
        if (((AbstractKoboldState)((Object)kobold)).isPassenger) {
            this.rightLeg.xRot = -1.5708f;
            this.leftLeg.xRot = -1.5708f;
            this.rightLeg.yRot = 0.2618f;
            this.leftLeg.yRot = -0.2618f;
        }
        if (!kobold.getMainHandItem().isEmpty()) {
            if (((AbstractKoboldState)((Object)kobold)).isAggressive) {
                if (((AbstractKoboldState)((Object)kobold)).isLeftHanded) {
                    if (((AbstractKoboldState)((Object)kobold)).getMainhandItem().getItem() instanceof BowItem) {
                        this.leftArm.xRot = -1.4399f;
                        this.leftArm.yRot = 0.2618f;
                        this.rightArm.xRot = -1.3963f;
                        this.rightArm.yRot = -0.3054f;
                    } else {
                        this.leftArm.xRot = -2.0944f;
                        this.leftArm.yRot = -0.1745f;
                    }
                } else if (((AbstractKoboldState)((Object)kobold)).getMainhandItem().getItem() instanceof BowItem) {
                    this.rightArm.xRot = -1.4399f;
                    this.rightArm.yRot = -0.2618f;
                    this.leftArm.xRot = -1.3963f;
                    this.leftArm.yRot = 0.3054f;
                } else {
                    this.rightArm.xRot = -2.0944f;
                    this.rightArm.yRot = 0.1745f;
                }
            } else if (((AbstractKoboldState)((Object)kobold)).getMainhandItem().getItem() instanceof CrossbowItem) {
                if (((AbstractKoboldState)((Object)kobold)).isLeftHanded) {
                    if (((AbstractKoboldState)((Object)kobold)).isCharging) {
                        this.leftArm.xRot = -0.6981f;
                        this.leftArm.yRot = 0.3491f;
                        this.rightArm.xRot = -1.1345f;
                        this.rightArm.yRot = -0.5672f;
                    } else if (CrossbowItem.isCharged((ItemStack)((AbstractKoboldState)((Object)kobold)).getMainhandItem())) {
                        this.leftArm.xRot = -1.4399f;
                        this.leftArm.yRot = 0.2618f;
                        this.rightArm.xRot = -1.3963f;
                        this.rightArm.yRot = -0.3054f;
                    }
                } else if (((AbstractKoboldState)((Object)kobold)).isCharging) {
                    this.rightArm.xRot = -0.6981f;
                    this.rightArm.yRot = -0.3491f;
                    this.leftArm.xRot = -1.1345f;
                    this.leftArm.yRot = 0.5672f;
                } else if (CrossbowItem.isCharged((ItemStack)((AbstractKoboldState)((Object)kobold)).getMainhandItem())) {
                    this.rightArm.xRot = -1.4399f;
                    this.rightArm.yRot = -0.2618f;
                    this.leftArm.xRot = -1.3963f;
                    this.leftArm.yRot = 0.3054f;
                }
            }
        }
        if (((AbstractKoboldState)((Object)kobold)).attackTime > 0.0f) {
            if (((AbstractKoboldState)((Object)kobold)).isLeftHanded) {
                float progress = ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress = 1.0f - ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                this.leftArm.xRot = (float)((double)this.leftArm.xRot - ((double)f2 / 1.2 - 1.0));
            } else {
                float progress = ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress = 1.0f - ((AbstractKoboldState)((Object)kobold)).attackTime;
                progress *= progress;
                progress *= progress;
                progress = 1.0f - progress;
                float f2 = Mth.sin((float)(progress * (float)Math.PI));
                this.rightArm.xRot = (float)((double)this.rightArm.xRot - ((double)f2 / 1.2 - 1.0));
            }
        }
    }

    public void translateToHand(HumanoidArm arm, PoseStack pose) {
        switch (arm) {
            case LEFT: {
                this.leftArm.translateAndRotate(pose);
                pose.translate(0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
                break;
            }
            case RIGHT: {
                this.rightArm.translateAndRotate(pose);
                pose.translate(-0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }
}

