/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.event.EventHooks;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldCaptain;
import net.salju.kobolds.entity.KoboldEnchanter;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldZombie
extends Zombie {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING = SynchedEntityData.defineId(KoboldZombie.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.defineId(KoboldZombie.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private int zomboType;
    private int convert;

    public KoboldZombie(EntityType<KoboldZombie> type, Level world) {
        super(type, world);
        this.setPersistenceRequired();
        this.getEyePosition(0.5f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CONVERTING, (Object)false);
        builder.define(DATA_TYPE, (Object)"base");
    }

    protected void registerGoals() {
        super.registerGoals();
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ZomboType", this.zomboType);
        tag.putInt("Convert", this.convert);
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        this.setZombo(tag.getInt("ZomboType").orElse(6));
        this.convert = tag.getInt("Convert").orElse(0);
    }

    protected boolean convertsInWater() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public boolean isConvert() {
        return (Boolean)this.getEntityData().get(DATA_CONVERTING);
    }

    public String getZomboType() {
        return (String)this.getEntityData().get(DATA_TYPE);
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.ZOMBIE_VILLAGER_AMBIENT;
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ZOMBIE_VILLAGER_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_VILLAGER_DEATH;
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide() && this.isAlive() && !this.isNoAi()) {
            if (this.convert > 1) {
                --this.convert;
                if (!this.isConvert()) {
                    this.getEntityData().set(DATA_CONVERTING, (Object)true);
                }
            } else if (this.convert == 1 && this.isAlive()) {
                this.playSound(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, 1.0f, 1.0f);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    if (this.zomboType <= 1) {
                        KoboldCaptain capty = (KoboldCaptain)this.convertTo((EntityType)KoboldsMobs.KOBOLD_CAPTAIN.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                        capty.setCanPickUpLoot(true);
                    } else if (this.zomboType == 2) {
                        Kobold pirate = (Kobold)this.convertTo((EntityType)KoboldsMobs.KOBOLD_PIRATE.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                        pirate.setCanPickUpLoot(true);
                    } else if (this.zomboType == 3) {
                        KoboldWarrior war = (KoboldWarrior)this.convertTo((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                        war.setCanPickUpLoot(true);
                    } else if (this.zomboType == 4) {
                        KoboldEngineer engi = (KoboldEngineer)this.convertTo((EntityType)KoboldsMobs.KOBOLD_ENGINEER.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                        engi.setCanPickUpLoot(true);
                    } else if (this.zomboType == 5) {
                        KoboldEnchanter magic = (KoboldEnchanter)this.convertTo((EntityType)KoboldsMobs.KOBOLD_ENCHANTER.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                        magic.setCanPickUpLoot(true);
                    } else {
                        Kobold basic = (Kobold)this.convertTo((EntityType)KoboldsMobs.KOBOLD.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                        basic.setCanPickUpLoot(true);
                    }
                }
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack apple = player.getItemInHand(hand);
        int waitTicks = 0;
        int potionLevel = 0;
        if (!this.level().isClientSide() && apple.getItem() == Items.GOLDEN_APPLE && this.hasEffect(MobEffects.WEAKNESS)) {
            if (this.level().getDifficulty() == Difficulty.EASY) {
                potionLevel = 0;
                waitTicks = 1200;
            } else if (this.level().getDifficulty() == Difficulty.NORMAL) {
                potionLevel = 0;
                waitTicks = 2400;
            } else if (this.level().getDifficulty() == Difficulty.HARD) {
                potionLevel = 1;
                waitTicks = 4800;
            }
            if (!player.isCreative()) {
                apple.shrink(1);
            }
            player.swing(hand, true);
            this.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, 1.0f, 1.0f);
            this.removeEffect(MobEffects.WEAKNESS);
            this.addEffect(new MobEffectInstance(MobEffects.STRENGTH, waitTicks, potionLevel));
            this.convert = waitTicks;
            this.getEntityData().set(DATA_CONVERTING, (Object)true);
        }
        return super.mobInteract(player, hand);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData data) {
        if (reason != EntitySpawnReason.CONVERSION) {
            this.setZombo(Mth.nextInt((RandomSource)world.getRandom(), (int)1, (int)6));
            this.populateDefaultEquipmentSlots(world.getRandom(), difficulty);
            this.populateDefaultEquipmentEnchantments(world, world.getRandom(), difficulty);
        }
        return super.finalizeSpawn(world, difficulty, reason, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        if (this.getZomboType().equals("warrior")) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_AXE.get()));
            this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
        } else if (this.getZomboType().equals("pirate_captain")) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        } else if (this.getZomboType().equals("engineer")) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
        } else if (this.getZomboType().equals("base") || this.getZomboType().equals("pirate")) {
            if (Math.random() >= 0.6) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
            }
        }
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    public void setZombo(AbstractKoboldEntity kobold) {
        if (kobold.getType() == KoboldsMobs.KOBOLD_CAPTAIN.get()) {
            this.getEntityData().set(DATA_TYPE, (Object)"pirate_captain");
            this.zomboType = 1;
        } else if (kobold.getType() == KoboldsMobs.KOBOLD_PIRATE.get()) {
            this.getEntityData().set(DATA_TYPE, (Object)"pirate");
            this.zomboType = 2;
        } else if (kobold.getType() == KoboldsMobs.KOBOLD_WARRIOR.get()) {
            this.getEntityData().set(DATA_TYPE, (Object)"warrior");
            this.zomboType = 3;
        } else if (kobold.getType() == KoboldsMobs.KOBOLD_ENGINEER.get()) {
            this.getEntityData().set(DATA_TYPE, (Object)"engineer");
            this.zomboType = 4;
        } else if (kobold.getType() == KoboldsMobs.KOBOLD_ENCHANTER.get()) {
            this.getEntityData().set(DATA_TYPE, (Object)"enchanter");
            this.zomboType = 5;
        } else {
            this.getEntityData().set(DATA_TYPE, (Object)"base");
            this.zomboType = 6;
        }
    }

    public void setZombo(int i) {
        this.zomboType = i;
        if (i <= 1) {
            this.getEntityData().set(DATA_TYPE, (Object)"pirate_captain");
        } else if (i == 2) {
            this.getEntityData().set(DATA_TYPE, (Object)"pirate");
        } else if (i == 3) {
            this.getEntityData().set(DATA_TYPE, (Object)"warrior");
        } else if (i == 4) {
            this.getEntityData().set(DATA_TYPE, (Object)"engineer");
        } else if (i == 5) {
            this.getEntityData().set(DATA_TYPE, (Object)"enchanter");
        } else if (i >= 6) {
            this.getEntityData().set(DATA_TYPE, (Object)"base");
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 18.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
        return builder;
    }
}

