/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldCrossbowGoal<T extends AbstractKoboldEntity & CrossbowAttackMob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.rangeOfSeconds((int)1, (int)2);
    private final T kobold;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public KoboldCrossbowGoal(T t, double d1, float f1) {
        this.kobold = t;
        this.speedModifier = d1;
        this.attackRadiusSqr = f1 * f1;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        return this.kobold.getTarget() != null && this.kobold.getTarget().isAlive() && this.isHoldingCrossbow();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        super.start();
        this.kobold.setAggressive(true);
    }

    public void stop() {
        super.stop();
        this.kobold.setAggressive(false);
        this.kobold.setTarget(null);
        this.seeTime = 0;
        if (this.kobold.isUsingItem()) {
            this.kobold.stopUsingItem();
            ((AbstractKoboldEntity)((Object)this.kobold)).setChargingCrossbow(false);
        }
    }

    public void tick() {
        LivingEntity target = this.kobold.getTarget();
        if (target != null) {
            boolean flag2;
            boolean flag1;
            boolean flag = this.kobold.getSensing().hasLineOfSight((Entity)target);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            double d0 = this.kobold.distanceToSqr((Entity)target);
            boolean bl2 = flag2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (flag2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0) {
                    this.kobold.getNavigation().moveTo((Entity)target, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(this.kobold.getRandom());
                }
            } else {
                this.updatePathDelay = 0;
                this.kobold.getNavigation().stop();
            }
            this.kobold.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (!flag2) {
                    this.kobold.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.kobold, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((AbstractKoboldEntity)((Object)this.kobold)).setChargingCrossbow(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack stack;
                int i;
                if (!this.kobold.isUsingItem()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.kobold.getTicksUsingItem()) >= CrossbowItem.getChargeDuration((ItemStack)(stack = this.kobold.getUseItem()), this.kobold)) {
                    this.kobold.releaseUsingItem();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 20 + this.kobold.getRandom().nextInt(20);
                    ((AbstractKoboldEntity)((Object)this.kobold)).setChargingCrossbow(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag) {
                ((AbstractKoboldEntity)((Object)this.kobold)).performRangedAttack(target, 1.0f);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean isHoldingCrossbow() {
        return this.kobold.isHolding(stack -> stack.getItem() instanceof CrossbowItem);
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

