/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.salju.kobolds.Kobolds;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldPotionGoal
extends Goal {
    public final AbstractKoboldEntity kobold;

    public KoboldPotionGoal(AbstractKoboldEntity kobold) {
        this.kobold = kobold;
    }

    public boolean canUse() {
        return this.kobold.getOffhandItem().is(Items.POTION);
    }

    public void start() {
        this.kobold.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 32, 4, false, false));
        this.kobold.playSound((SoundEvent)SoundEvents.GENERIC_DRINK.value(), 0.5f, 1.0f);
        Kobolds.queueServerWork(32, () -> {
            PotionContents target = (PotionContents)this.kobold.getOffhandItem().get(DataComponents.POTION_CONTENTS);
            if (target != null) {
                target.forEachEffect(arg_0 -> ((AbstractKoboldEntity)this.kobold).addEffect(arg_0), ((Float)this.kobold.getOffhandItem().getOrDefault(DataComponents.POTION_DURATION_SCALE, (Object)Float.valueOf(1.0f))).floatValue());
            }
            this.kobold.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        });
    }
}

