/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ShieldItem;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldShieldGoal
extends Goal {
    public final AbstractKoboldEntity kobold;

    public KoboldShieldGoal(AbstractKoboldEntity kobold) {
        this.kobold = kobold;
    }

    public boolean canUse() {
        return this.kobold.getOffhandItem().getItem() instanceof ShieldItem && this.raiseShield();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        super.start();
        this.kobold.startUsingItem(InteractionHand.OFF_HAND);
    }

    public void stop() {
        super.stop();
        this.kobold.stopUsingItem();
    }

    protected boolean raiseShield() {
        if (this.kobold.getTarget() != null && this.kobold.getTarget().isAlive() && this.kobold.getCD() <= 0) {
            LivingEntity target = this.kobold.getTarget();
            return target instanceof RangedAttackMob && (double)this.kobold.distanceTo((Entity)target) >= 0.2 || (double)this.kobold.distanceTo((Entity)target) >= 0.2 && (double)this.kobold.distanceTo((Entity)target) <= 5.2;
        }
        return false;
    }
}

