/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldSpecialRangeGoal<T extends AbstractKoboldEntity>
extends Goal {
    private final T kobold;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public KoboldSpecialRangeGoal(T t, double d, float f) {
        this.kobold = t;
        this.speedModifier = d;
        this.attackRadiusSqr = f * f;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.kobold.getTarget() != null && this.kobold.getTarget().isAlive() && this.isHoldingWeapon();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        super.start();
        this.kobold.setAggressive(true);
        this.kobold.startUsingItem(ProjectileUtil.getWeaponHoldingHand(this.kobold, item -> new ItemStack((ItemLike)item).is(KoboldsTags.RANGED)));
    }

    public void stop() {
        super.stop();
        this.kobold.setAggressive(false);
        this.kobold.getMoveControl().strafe(0.0f, 0.0f);
        this.kobold.getNavigation().stop();
        this.kobold.stopUsingItem();
    }

    public void tick() {
        super.tick();
        if (this.kobold.getTarget() != null) {
            double d = this.kobold.distanceToSqr(this.kobold.getTarget().getX(), this.kobold.getTarget().getY(), this.kobold.getTarget().getZ());
            boolean flag = this.kobold.getSensing().hasLineOfSight((Entity)this.kobold.getTarget());
            if (flag != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (!(d > (double)this.attackRadiusSqr) && this.seeTime >= 20) {
                this.kobold.getNavigation().stop();
                ++this.strafingTime;
            } else {
                this.kobold.getNavigation().moveTo((Entity)this.kobold.getTarget(), this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.kobold.getRandom().nextFloat() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.kobold.getRandom().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.kobold.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity veh = this.kobold.getControlledVehicle();
                if (veh instanceof Mob) {
                    Mob target = (Mob)veh;
                    target.lookAt((Entity)this.kobold.getTarget(), 30.0f, 30.0f);
                }
                this.kobold.lookAt((Entity)this.kobold.getTarget(), 30.0f, 30.0f);
                this.kobold.getLookControl().setLookAt(this.kobold.getTarget().getX(), this.kobold.getTarget().getEyeY(), this.kobold.getTarget().getZ());
            } else {
                this.kobold.getLookControl().setLookAt((Entity)this.kobold.getTarget(), 30.0f, 30.0f);
                this.kobold.getLookControl().setLookAt(this.kobold.getTarget().getX(), this.kobold.getTarget().getEyeY(), this.kobold.getTarget().getZ());
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected boolean isHoldingWeapon() {
        return this.kobold.isHolding(stack -> stack.is(KoboldsTags.RANGED));
    }
}

