/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.TridentItem;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldTridentGoal
extends RangedAttackGoal {
    public final AbstractKoboldEntity kobold;

    public KoboldTridentGoal(RangedAttackMob kobold, double dub, int inty, float enty) {
        super(kobold, dub, inty, enty);
        this.kobold = (AbstractKoboldEntity)kobold;
    }

    public boolean canUse() {
        return super.canUse() && this.isHoldingTrident();
    }

    public void start() {
        super.start();
        this.kobold.setAggressive(true);
        this.kobold.startUsingItem(InteractionHand.MAIN_HAND);
    }

    public void stop() {
        super.stop();
        this.kobold.setAggressive(false);
        this.kobold.stopUsingItem();
    }

    private boolean isHoldingTrident() {
        return this.kobold.isHolding(stack -> stack.getItem() instanceof TridentItem);
    }
}

