/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity.ai;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.salju.kobolds.Kobolds;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldWarriorGoal
extends Goal {
    public final AbstractKoboldEntity kobold;

    public KoboldWarriorGoal(AbstractKoboldEntity kobold) {
        this.kobold = kobold;
    }

    public boolean canUse() {
        return this.checkHand() && !this.kobold.hasEffect(MobEffects.SLOWNESS);
    }

    public void start() {
        this.kobold.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 600, 10, false, false));
        Kobolds.queueServerWork(600, () -> {
            ItemStack weapon = this.kobold.getMainHandItem();
            ItemStack off = this.kobold.getOffhandItem();
            Level world = this.kobold.level();
            double x = this.kobold.getX();
            double y = this.kobold.getY();
            double z = this.kobold.getZ();
            if (world instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)world;
                ItemEntity drop = new ItemEntity((Level)lvl, x, y, z, weapon);
                drop.setPickUpDelay(10);
                world.addFreshEntity((Entity)drop);
                this.kobold.setItemSlot(EquipmentSlot.MAINHAND, off);
                this.kobold.setDropChance(EquipmentSlot.MAINHAND, 1.0f);
                this.kobold.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
                this.kobold.convertTo((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), ConversionParams.single((Mob)this.kobold, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this.kobold, (LivingEntity)newbie));
            }
        });
    }

    protected boolean checkHand() {
        return this.kobold.getOffhandItem().getItem() instanceof AxeItem;
    }
}

