/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.event.EventHooks;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldZombie;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;
import net.salju.kobolds.init.KoboldsSounds;
import net.salju.kobolds.init.KoboldsTags;

public abstract class AbstractKoboldEntity
extends PathfinderMob
implements CrossbowAttackMob,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.defineId(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_DIAMOND_EYES = SynchedEntityData.defineId(AbstractKoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Optional<EntityReference<Entity>> thrownTrident = Optional.empty();
    private ItemStack primary = new ItemStack(KoboldsItems.KOBOLD_IRON_SWORD);
    private ItemStack trident = ItemStack.EMPTY;
    private int breed;
    private int cooldown;
    private int potion;

    protected AbstractKoboldEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.setCanPickUpLoot(true);
        this.setPersistenceRequired();
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.primary.isEmpty()) {
            tag.put("Primary", this.primary.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
        if (!this.trident.isEmpty()) {
            tag.put("Trident", this.trident.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
        }
        if (this.getTridentReference() != null) {
            this.getTridentReference().store(tag, "ThrownTrident");
        }
        tag.putInt("Breed", this.breed);
        tag.putInt("CD", this.cooldown);
        tag.putInt("PCD", this.potion);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.getCompound("Primary").isPresent() && ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)((Tag)tag.getCompound("Primary").get())).isPresent()) {
            this.primary = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)((Tag)tag.getCompound("Primary").get())).get();
        }
        if (tag.getCompound("Trident").isPresent() && ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)((Tag)tag.getCompound("Trident").get())).isPresent()) {
            this.trident = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)((Tag)tag.getCompound("Trident").get())).get();
        }
        if (tag.contains("ThrownTrident")) {
            EntityReference target = EntityReference.read((CompoundTag)tag, (String)"ThrownTrident");
            this.thrownTrident = target != null ? Optional.of(target) : Optional.empty();
        }
        this.breed = tag.getInt("Breed").orElse(0);
        this.cooldown = tag.getInt("CD").orElse(0);
        this.potion = tag.getInt("PCD").orElse(0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CHARGING_STATE, (Object)false);
        builder.define(DATA_DIAMOND_EYES, (Object)false);
    }

    public void performRangedAttack(LivingEntity target, float f) {
        InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, stack -> stack instanceof CrossbowItem || stack instanceof BowItem || stack instanceof TridentItem);
        if (this.getItemInHand(hand).getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, 2.0f);
        } else if (this.getItemInHand(hand).getItem() instanceof BowItem) {
            AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)this.getProjectile(this.getItemInHand(hand)), (float)f, (ItemStack)this.getItemInHand(hand));
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - arrow.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            arrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)arrow);
        } else if (this.getItemInHand(hand).getItem() instanceof TridentItem) {
            this.trident = this.getItemInHand(hand);
            ThrownTrident proj = new ThrownTrident(this.level(), (LivingEntity)this, this.trident);
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - proj.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            proj.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.DROWNED_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)proj);
            this.setItemInHand(InteractionHand.MAIN_HAND, this.primary);
            this.setTrident(proj);
            this.setCD(1200);
        }
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_CHARGING_STATE);
    }

    public void setChargingCrossbow(boolean check) {
        this.entityData.set(DATA_CHARGING_STATE, (Object)check);
    }

    public ItemStack equipItemIfPossible(ServerLevel lvl, ItemStack stack) {
        EquipmentSlot slot = this.getEquipmentSlotForItem(stack);
        ItemStack current = this.getItemBySlot(slot);
        boolean flag = this.canReplaceCurrentItem(stack, current, slot);
        if (stack.is(Items.EMERALD)) {
            slot = EquipmentSlot.OFFHAND;
            current = this.getItemBySlot(slot);
            flag = this.canReplaceCurrentItem(stack, current, slot);
        }
        if (flag && this.canHoldItem(stack)) {
            if (!current.isEmpty() && !(stack.getItem() instanceof TridentItem) && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < (double)this.getDropChances().byEquipment(slot)) {
                this.spawnAtLocation(lvl, current);
            }
            if (stack.is(Items.EMERALD) && stack.getCount() > 1) {
                stack = stack.split(1);
            }
            if (slot.isArmor() && stack.getCount() > 1) {
                ItemStack copy = stack.copyWithCount(1);
                this.setItemSlotAndDropWhenKilled(slot, copy);
                return copy;
            }
            this.setItemSlotAndDropWhenKilled(slot, stack);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    protected boolean canReplaceCurrentItem(ItemStack drop, ItemStack hand, EquipmentSlot slot) {
        if (EnchantmentHelper.hasTag((ItemStack)drop, (TagKey)EnchantmentTags.CURSE)) {
            return false;
        }
        if (drop.getItem() instanceof TridentItem) {
            if (hand.getItem() instanceof TridentItem && this.canReplaceEqualItem(drop, hand)) {
                this.trident = drop;
                return true;
            }
            if (this.trident.isEmpty() && hand.is(ItemTags.SWORDS)) {
                this.primary = this.getMainHandItem();
                this.trident = drop;
                return true;
            }
            return false;
        }
        if (this.isPreferredWeapon(drop)) {
            if (hand.getItem() instanceof TridentItem) {
                return false;
            }
            if (this.isPreferredWeapon(hand)) {
                return this.canReplaceEqualItem(drop, hand);
            }
            return true;
        }
        if (this.isPreferredWeapon(hand)) {
            return false;
        }
        if (drop.getItem() instanceof ShieldItem) {
            if (hand.getItem() instanceof ShieldItem) {
                return this.canReplaceEqualItem(drop, hand);
            }
            if (hand.isEmpty()) {
                return true;
            }
        } else {
            if (drop.is(Items.EMERALD) && hand.isEmpty() && this.getType().is(KoboldsTags.TRADERS)) {
                return true;
            }
            if (drop.is(KoboldsTags.ARMOR)) {
                return hand.isEmpty() || this.canReplaceEqualItem(drop, hand);
            }
        }
        return false;
    }

    public boolean canReplaceEqualItem(ItemStack drop, ItemStack hand) {
        if (drop.isEnchanted()) {
            if (hand.isEnchanted()) {
                int id = 0;
                ItemEnchantments.Mutable dropMap = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)drop));
                for (Holder e : dropMap.keySet()) {
                    if (e.is(KoboldsTags.ENCHS)) {
                        id += 5 * dropMap.getLevel(e);
                        continue;
                    }
                    id += dropMap.getLevel(e);
                }
                int ih = 0;
                ItemEnchantments.Mutable handMap = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)hand));
                for (Holder e : handMap.keySet()) {
                    if (e.is(KoboldsTags.ENCHS)) {
                        ih += 5 * handMap.getLevel(e);
                        continue;
                    }
                    ih += handMap.getLevel(e);
                }
                if (id > ih) {
                    return true;
                }
                if (this.isPreferredWeapon(drop) && id == ih) {
                    return drop.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND) > hand.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND);
                }
            }
            return !hand.isEnchanted();
        }
        if (this.isPreferredWeapon(drop) && !hand.isEnchanted()) {
            return drop.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND) > hand.getAttributeModifiers().compute(this.getAttributeBaseValue(Attributes.ATTACK_DAMAGE), EquipmentSlot.MAINHAND);
        }
        return super.canReplaceEqualItem(drop, hand);
    }

    public void aiStep() {
        super.aiStep();
        this.updateSwingTime();
    }

    public SoundEvent getAmbientSound() {
        return this.isBaby() ? (SoundEvent)KoboldsSounds.KOBOLD_YIP.get() : (SoundEvent)KoboldsSounds.KOBOLD_IDLE.get();
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return this.isBlocking() ? (SoundEvent)SoundEvents.SHIELD_BLOCK.value() : (SoundEvent)KoboldsSounds.KOBOLD_HURT.get();
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)KoboldsSounds.KOBOLD_DEATH.get();
    }

    public void die(DamageSource source) {
        if (source.getDirectEntity() instanceof Zombie && !this.isBaby()) {
            this.playSound(SoundEvents.ZOMBIE_VILLAGER_CONVERTED, 1.0f, 1.0f);
            if (this.level() instanceof ServerLevel) {
                InteractionHand hand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, stack -> stack == Items.POTION);
                if (this.getItemInHand(hand).is(Items.POTION)) {
                    this.setItemInHand(hand, ItemStack.EMPTY);
                }
                KoboldZombie zombo = (KoboldZombie)this.convertTo((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get(), ConversionParams.single((Mob)this, (boolean)true, (boolean)true), newbie -> EventHooks.onLivingConvert((LivingEntity)this, (LivingEntity)newbie));
                zombo.setZombo(this);
            }
        }
        super.die(source);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack gem = player.getItemInHand(hand).copy();
        if (this.isAlive()) {
            if (player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty()) {
                this.playSound((SoundEvent)KoboldsSounds.KOBOLD_PURR.get(), 1.0f, this.isBaby() ? 1.2f : 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!this.isBaby()) {
                if (gem.is((Item)KoboldsItems.KOBOLD_SPAWN_EGG.get())) {
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)level;
                        ((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).spawn(lvl, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), EntitySpawnReason.BREEDING);
                    }
                    if (!player.isCreative()) {
                        player.getItemInHand(hand).shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (gem.is(Items.AMETHYST_SHARD) && this.breed <= 0) {
                    if (this.isEffectiveAi()) {
                        this.setBreed(20000);
                        if (!player.isCreative()) {
                            player.getItemInHand(hand).shrink(1);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (this.getOffhandItem().isEmpty()) {
                    if (gem.getItem() instanceof AxeItem && hand != InteractionHand.MAIN_HAND && this instanceof Kobold) {
                        if (this.isEffectiveAi()) {
                            this.setItemInHand(InteractionHand.OFF_HAND, gem);
                            if (!player.isCreative()) {
                                player.getItemInHand(hand).shrink(1);
                            }
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (gem.is(Items.EMERALD) && this.getType().is(KoboldsTags.TRADERS)) {
                        if (this.isEffectiveAi()) {
                            gem.setCount(1);
                            this.setItemInHand(InteractionHand.OFF_HAND, gem);
                            if (!player.isCreative()) {
                                player.getItemInHand(hand).shrink(1);
                            }
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
            }
        }
        return super.mobInteract(player, hand);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData data) {
        this.populateDefaultEquipmentSlots(world.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(world, world.getRandom(), difficulty);
        return super.finalizeSpawn(world, difficulty, reason, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        if (this.getType() == KoboldsMobs.KOBOLD_WARRIOR.get()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_AXE.get()));
            this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
        } else if (this.getType() == KoboldsMobs.KOBOLD_RASCAL.get() || this.getType() == KoboldsMobs.KOBOLD_CAPTAIN.get()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        } else if (this.getType() == KoboldsMobs.KOBOLD_ENGINEER.get()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
        } else if (this.getType() == KoboldsMobs.KOBOLD.get() || this.getType() == KoboldsMobs.KOBOLD_PIRATE.get()) {
            if (Math.random() >= 0.6) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.CROSSBOW));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
            }
            if (this.getType() == KoboldsMobs.KOBOLD_PIRATE.get() && Math.random() >= 0.75) {
                this.primary = this.getMainHandItem();
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.TRIDENT));
                this.trident = new ItemStack((ItemLike)Items.TRIDENT);
            }
        }
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    public ItemStack getProjectile(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
            ItemStack extra = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)weapon.getSupportedHeldProjectiles(stack));
            return extra.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : extra;
        }
        return super.getProjectile(stack);
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide() && this.isAlive() && this.isEffectiveAi()) {
            this.checkTrident();
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.potion > 0) {
                --this.potion;
            } else if (this.getHealth() < 12.0f) {
                this.givePotion(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.STRONG_HEALING), 600);
            }
            if (this.breed > 0) {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    if (this.breed > 18000) {
                        AbstractKoboldEntity target = (AbstractKoboldEntity)lvl.getNearestEntity(AbstractKoboldEntity.class, TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight(), (LivingEntity)this, this.getX(), this.getY(), this.getZ(), this.getBoundingBox().inflate(8.0));
                        if (Mth.nextInt((RandomSource)this.random, (int)1, (int)10) > 8) {
                            double d = this.random.nextGaussian() * 0.02;
                            lvl.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 3, d, d, d, 0.0);
                        }
                        if (target != null && !target.is((Entity)this) && target.getBreed() > 18000) {
                            if ((double)this.distanceTo((Entity)target) >= 1.0) {
                                this.getNavigation().moveTo((Entity)target, 1.0);
                            } else if ((double)this.distanceTo((Entity)target) < 1.0) {
                                BlockPos pos = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ());
                                ((EntityType)KoboldsMobs.KOBOLD_CHILD.get()).spawn(lvl, pos, EntitySpawnReason.BREEDING);
                                target.setBreed(18000);
                                this.setBreed(18000);
                            }
                        }
                    }
                }
                if (!this.isDiamond()) {
                    this.getEntityData().set(DATA_DIAMOND_EYES, (Object)true);
                }
                --this.breed;
                if (this.breed <= 0 && this.isDiamond()) {
                    this.getEntityData().set(DATA_DIAMOND_EYES, (Object)false);
                }
            }
        }
    }

    public boolean hurtServer(ServerLevel lvl, DamageSource source, float amount) {
        Entity entity;
        if (!this.level().isClientSide() && this.isAlive() && this.isEffectiveAi() && this.getPotionCD() <= 0) {
            if ((source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.LAVA)) && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                this.givePotion(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_FIRE_RESISTANCE), 120);
            } else if (source.is(DamageTypes.DROWN) && !this.hasEffect(MobEffects.WATER_BREATHING)) {
                this.givePotion(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.LONG_WATER_BREATHING), 120);
            }
        }
        if (this.isBlocking() && (entity = source.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity atk = (LivingEntity)entity;
            this.setCD((int)atk.getSecondsToDisableBlocking() * 20);
        }
        return !(source.getEntity() instanceof AbstractKoboldEntity) && !source.is(DamageTypes.CAMPFIRE) && super.hurtServer(lvl, source, amount);
    }

    public void givePotion(ItemStack stack, int i) {
        if (this.getOffhandItem().isEmpty()) {
            this.setItemInHand(InteractionHand.OFF_HAND, stack);
            this.setPotionCD(i);
        }
    }

    public void checkTrident() {
        Level level;
        if (this.getTridentReference() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            if (this.cooldown <= 1180) {
                ThrownTrident proj;
                Entity entity = lvl.getEntity(this.getTridentReference().getUUID());
                if (entity instanceof ThrownTrident && (proj = (ThrownTrident)entity).getOwner().is((Entity)this)) {
                    if ((double)this.distanceTo((Entity)proj) < 2.0 || this.cooldown <= 1) {
                        this.giveTrident(proj);
                    } else if ((double)this.distanceTo((Entity)proj) < 32.0 && this.getTarget() == null) {
                        this.getNavigation().moveTo((Entity)proj, 1.0);
                    }
                } else if (lvl.getEntity(this.getTridentReference().getUUID()) == null && this.cooldown <= 1) {
                    this.giveTrident(null);
                }
            }
        }
    }

    protected void giveTrident(@Nullable ThrownTrident proj) {
        this.primary = this.getMainHandItem();
        this.setItemInHand(InteractionHand.MAIN_HAND, this.trident);
        this.setTrident(null);
        if (this.cooldown > 1 && proj != null) {
            this.setCD(0);
            proj.discard();
        }
    }

    public void setCD(int i) {
        this.cooldown = i;
    }

    public void setBreed(int i) {
        this.breed = i;
    }

    public void setPotionCD(int i) {
        this.potion = i;
    }

    public void setTrident(@Nullable ThrownTrident proj) {
        this.thrownTrident = Optional.ofNullable(proj).map(EntityReference::new);
    }

    public boolean isDiamond() {
        return (Boolean)this.getEntityData().get(DATA_DIAMOND_EYES);
    }

    public int getCD() {
        return this.cooldown;
    }

    public int getBreed() {
        return this.breed;
    }

    public int getPotionCD() {
        return this.potion;
    }

    public boolean isPreferredWeapon(ItemStack stack) {
        return stack.is(KoboldsTags.BASIC);
    }

    @Nullable
    public EntityReference<Entity> getTridentReference() {
        return this.thrownTrident.orElse(null);
    }

    public static List<ItemStack> getTradeItems(AbstractKoboldEntity kobold, String table) {
        return Objects.requireNonNull(kobold.level().getServer()).reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)table))).getRandomItems(new LootParams.Builder((ServerLevel)kobold.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)kobold).create(LootContextParamSets.EMPTY));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.MAX_HEALTH, 18.0);
        builder = builder.add(Attributes.ARMOR, 2.0);
        return builder;
    }
}

