/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.salju.kobolds.compat.Supplementaries;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.ai.KoboldAttackSelector;
import net.salju.kobolds.entity.ai.KoboldBowGoal;
import net.salju.kobolds.entity.ai.KoboldCrossbowGoal;
import net.salju.kobolds.entity.ai.KoboldPotionGoal;
import net.salju.kobolds.entity.ai.KoboldRevengeGoal;
import net.salju.kobolds.entity.ai.KoboldSpecialRangeGoal;
import net.salju.kobolds.entity.ai.KoboldTargetGoal;
import net.salju.kobolds.entity.ai.KoboldTradeGoal;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldEngineer
extends AbstractKoboldEntity {
    public KoboldEngineer(EntityType<KoboldEngineer> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(0, (Goal)new KoboldRevengeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldPotionGoal(this));
        if (ModList.get().isLoaded("supplementaries")) {
            Supplementaries.addGoals(this);
        }
        this.goalSelector.addGoal(1, new KoboldCrossbowGoal<KoboldEngineer>(this, 1.0, 12.0f));
        this.goalSelector.addGoal(1, new KoboldSpecialRangeGoal<KoboldEngineer>(this, 1.0, 12.0f));
        this.goalSelector.addGoal(1, new KoboldBowGoal<KoboldEngineer>(this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(1, (Goal)new KoboldTradeGoal(this, "gameplay/engineer_loot"));
        this.targetSelector.addGoal(2, new KoboldTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, new KoboldAttackSelector(this)));
    }

    @Override
    public boolean isPreferredWeapon(ItemStack stack) {
        return stack.is(KoboldsTags.ENGI);
    }
}

