/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.Enhancements.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record WeaknessAspect() implements EnchantmentEntityEffect
{
    public static final MapCodec<WeaknessAspect> CODEC = MapCodec.unit(WeaknessAspect::new);

    public void apply(ServerLevel level, int enchantLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        float chance;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        RandomSource rng = level.getRandom();
        float f = chance = enchantLevel >= 2 ? 0.5f : 0.25f;
        if (rng.nextFloat() >= chance) {
            return;
        }
        int amplifier = enchantLevel >= 2 ? 1 : 0;
        int duration = 100;
        living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration, amplifier));
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

