/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.Enhancements.overide;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EtherealHandler {
    public static final String TAG_INFINITE_SHOT = "runic_infinity_success";

    private EtherealHandler() {
    }

    @SubscribeEvent
    public static void onArrowSpawn(EntityJoinLevelEvent e) {
        Entity ent = e.getEntity();
        if (!(ent instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)ent;
        Entity entity = arrow.getOwner();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.getAbilities().instabuild) {
            return;
        }
        if (EtherealHandler.isShotFromCrossbow(arrow)) {
            return;
        }
        if (arrow.pickup != AbstractArrow.Pickup.CREATIVE_ONLY) {
            return;
        }
        if (player.getRandom().nextBoolean()) {
            arrow.setGlowingTag(true);
            if (arrow instanceof Arrow) {
                Arrow normal = (Arrow)arrow;
                CompoundTag tag = normal.getPersistentData();
                tag.putBoolean(TAG_INFINITE_SHOT, true);
            }
        } else {
            EtherealHandler.consumeOneArrow(player);
            arrow.pickup = AbstractArrow.Pickup.ALLOWED;
        }
    }

    private static boolean isShotFromCrossbow(AbstractArrow arrow) {
        try {
            return (Boolean)AbstractArrow.class.getMethod("isShotFromCrossbow", new Class[0]).invoke((Object)arrow, new Object[0]);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static void consumeOneArrow(Player player) {
        Item[] pref;
        for (Item it : pref = new Item[]{Items.ARROW, Items.TIPPED_ARROW, Items.SPECTRAL_ARROW}) {
            int idx = EtherealHandler.findFirst(player, it);
            if (idx < 0) continue;
            player.getInventory().getItem(idx).shrink(1);
            return;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (s.isEmpty() || !(s.getItem() instanceof ArrowItem)) continue;
            s.shrink(1);
            return;
        }
    }

    private static int findFirst(Player player, Item item) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack s = player.getInventory().getItem(i);
            if (s.isEmpty() || !s.is(item)) continue;
            return i;
        }
        return -1;
    }
}

