/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.client;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class EnchantOverlayUtil {
    public static final ResourceLocation ICON_WEAPON = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/weapon.png");
    public static final ResourceLocation ICON_ARMOR = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/armor.png");
    public static final ResourceLocation ICON_BOOTS = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/boots.png");
    public static final ResourceLocation ICON_TOOL = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/tool.png");
    public static final ResourceLocation ICON_BOW = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/bow.png");
    public static final ResourceLocation ICON_CROSSBOW = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/crossbow.png");
    public static final ResourceLocation ICON_TRIDENT = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/trident.png");
    public static final ResourceLocation ICON_ROD = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/rod.png");
    public static final ResourceLocation ICON_SHIELD = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/shield.png");
    public static final ResourceLocation ICON_STAR = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/enchant/star.png");
    private static final int SLOT_W = 16;
    private static final int SLOT_H = 16;
    private static final int ICON_W = 6;
    private static final int ICON_H = 6;

    private EnchantOverlayUtil() {
    }

    public static void drawCenteredIcon(GuiGraphics gg, ResourceLocation tex, int slotX, int slotY) {
        int x = slotX + 5;
        int y = slotY + 5;
        gg.pose().pushPose();
        gg.pose().translate(0.0f, 0.0f, 200.0f);
        gg.blit(tex, x, y, 0.0f, 0.0f, 6, 6, 6, 6);
        gg.pose().popPose();
    }

    public static ResourceLocation pickIcon(ItemStack stack) {
        ResourceLocation icon = EnchantOverlayUtil.pickIconFrom((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        if (icon != null) {
            return icon;
        }
        return EnchantOverlayUtil.pickIconFrom((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
    }

    private static ResourceLocation pickIconFrom(ItemEnchantments ench) {
        if (ench.isEmpty()) {
            return null;
        }
        for (Object2IntMap.Entry e : ench.entrySet()) {
            String id;
            ResourceKey key = ((Holder)e.getKey()).unwrapKey().orElse(null);
            if (key == null) continue;
            switch (id = key.location().getPath()) {
                case "sharpness": 
                case "smite": 
                case "bane_of_arthropods": 
                case "knockback": 
                case "fire_aspect": 
                case "looting": 
                case "sweeping_edge": 
                case "breach": {
                    return ICON_WEAPON;
                }
                case "density": 
                case "wind_burst": {
                    return ICON_SHIELD;
                }
                case "efficiency": 
                case "silk_touch": 
                case "fortune": {
                    return ICON_TOOL;
                }
                case "protection": 
                case "blast_protection": 
                case "fire_protection": 
                case "projectile_protection": 
                case "thorns": {
                    return ICON_ARMOR;
                }
                case "feather_falling": 
                case "depth_strider": 
                case "frost_walker": 
                case "soul_speed": 
                case "swift_sneak": {
                    return ICON_BOOTS;
                }
                case "aqua_affinity": 
                case "respiration": {
                    return ICON_ARMOR;
                }
                case "power": 
                case "flame": 
                case "infinity": 
                case "punch": {
                    return ICON_BOW;
                }
                case "multishot": 
                case "piercing": 
                case "quick_charge": {
                    return ICON_CROSSBOW;
                }
                case "channeling": 
                case "loyalty": 
                case "riptide": 
                case "impaling": {
                    return ICON_TRIDENT;
                }
                case "luck_of_the_sea": 
                case "lure": {
                    return ICON_ROD;
                }
                case "unbreaking": 
                case "mending": 
                case "binding_curse": 
                case "vanishing_curse": {
                    return ICON_STAR;
                }
            }
        }
        return null;
    }
}

