/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class EtchingPreviewRenderer {
    private EtchingPreviewRenderer() {
    }

    public static void render(GuiGraphics gg, ItemStack stack, int absX, int absY, int w, int h, float partialTick) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        ClientLevel level = mc.level;
        gg.enableScissor(absX, absY, absX + w, absY + h);
        PoseStack ps = gg.pose();
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        ps.pushPose();
        ps.translate((float)absX + (float)w / 2.0f, (float)absY + (float)h * 0.55f, 200.0f);
        float s = (float)Math.min(w, h) * 0.9f / 16.0f * 10.0f;
        ps.scale(s, -s, s);
        float t = level != null ? (float)level.getGameTime() + partialTick : (float)((double)Util.getMillis() / 50.0);
        float yaw = t * 2.0f % 360.0f;
        ps.mulPose(Axis.XP.rotationDegrees(15.0f));
        ps.mulPose(Axis.YP.rotationDegrees(yaw));
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, ps, (MultiBufferSource)buffers, (Level)level, 0);
        ps.popPose();
        buffers.endBatch();
        gg.disableScissor();
    }
}

