/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="runic", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EtherealTrail {
    private static final DustParticleOptions BLUE_DUST = new DustParticleOptions(new Vector3f(0.23f, 0.65f, 1.0f), 1.0f);

    private EtherealTrail() {
    }

    @SubscribeEvent
    public static void onRenderStage(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.getCameraEntity() == null) {
            return;
        }
        AABB box = mc.getCameraEntity().getBoundingBox().inflate(64.0);
        List arrows = mc.level.getEntitiesOfClass(Arrow.class, box);
        for (Arrow a : arrows) {
            if (!a.isAlive() || a.pickup != AbstractArrow.Pickup.CREATIVE_ONLY || !a.isCurrentlyGlowing()) continue;
            Vec3 pos = a.position();
            mc.level.addParticle((ParticleOptions)BLUE_DUST, pos.x, pos.y + 0.05, pos.z, 0.0, 0.0, 0.0);
            Vec3 back = pos.subtract(a.getDeltaMovement().scale(0.3));
            mc.level.addParticle((ParticleOptions)BLUE_DUST, back.x, back.y + 0.03, back.z, 0.0, 0.0, 0.0);
        }
    }
}

