/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.revilodev.runic.item.ModItems;

@Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class RunicClientModels {
    private RunicClientModels() {
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"runic", (String)path);
    }

    @SubscribeEvent
    public static void registerAdditional(ModelEvent.RegisterAdditional e) {
        String[] models;
        for (String path : models = new String[]{"item/rune/minecraft/protection", "item/rune/minecraft/fire_protection", "item/rune/minecraft/blast_protection", "item/rune/minecraft/projectile_protection", "item/rune/minecraft/thorns", "item/rune/minecraft/respiration", "item/rune/minecraft/aqua_affinity", "item/rune/minecraft/depth_strider", "item/rune/minecraft/frost_walker", "item/rune/minecraft/soul_speed", "item/rune/minecraft/feather_falling", "item/rune/minecraft/sharpness", "item/rune/minecraft/smite", "item/rune/minecraft/bane_of_arthropods", "item/rune/minecraft/knockback", "item/rune/minecraft/fire_aspect", "item/rune/minecraft/looting", "item/rune/minecraft/sweeping_edge", "item/rune/runic/lightning_aspect", "item/rune/runic/poison_aspect", "item/rune/runic/slowness_aspect", "item/rune/runic/weakness_aspect", "item/rune/runic/swift_strike", "item/rune/runic/swift", "item/rune/minecraft/efficiency", "item/rune/minecraft/silk_touch", "item/rune/minecraft/fortune", "item/rune/minecraft/unbreaking", "item/rune/minecraft/mending", "item/rune/minecraft/vanishing_curse", "item/rune/minecraft/binding_curse", "item/rune/minecraft/power", "item/rune/minecraft/punch", "item/rune/minecraft/flame", "item/rune/minecraft/infinity", "item/rune/minecraft/multishot", "item/rune/minecraft/piercing", "item/rune/minecraft/quick_charge", "item/rune/minecraft/impaling", "item/rune/minecraft/riptide", "item/rune/minecraft/loyalty", "item/rune/minecraft/channeling", "item/rune/minecraft/luck_of_the_sea", "item/rune/minecraft/lure", "item/rune/minecraft/breach", "item/rune/minecraft/density", "item/rune/minecraft/wind_burst", "item/rune/minecraft/swift_sneak", "item/rune/runic/smelting"}) {
            e.register(ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"runic", (String)path)));
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> ItemProperties.register((Item)((Item)ModItems.ENHANCED_RUNE.get()), (ResourceLocation)RunicClientModels.id("rune_model"), RunicClientModels::runePredicate));
    }

    private static float runePredicate(ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
        if (level == null) {
            return 0.0f;
        }
        Registry reg = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        int idx = 1;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.PROTECTION), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.FIRE_PROTECTION), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.BLAST_PROTECTION), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.PROJECTILE_PROTECTION), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.THORNS), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.RESPIRATION), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.AQUA_AFFINITY), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.DEPTH_STRIDER), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.FROST_WALKER), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.SOUL_SPEED), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.FEATHER_FALLING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.SHARPNESS), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.SMITE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.BANE_OF_ARTHROPODS), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.KNOCKBACK), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.FIRE_ASPECT), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.LOOTING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.SWEEPING_EDGE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:lightning_aspect"), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:poison_aspect"), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:slowness_aspect"), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:weakness_aspect"), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:swiftstrike"), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.EFFICIENCY), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.SILK_TOUCH), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.FORTUNE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.UNBREAKING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.MENDING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.VANISHING_CURSE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.BINDING_CURSE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.POWER), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.PUNCH), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.FLAME), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.INFINITY), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.MULTISHOT), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.PIERCING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.QUICK_CHARGE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.IMPALING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.RIPTIDE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.LOYALTY), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.CHANNELING), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.LUCK_OF_THE_SEA), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.LURE), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.BREACH), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.DENSITY), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.WIND_BURST), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Holder<Enchantment>)reg.getHolderOrThrow(Enchantments.SWIFT_SNEAK), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:swift"), stack)) {
            return idx;
        }
        ++idx;
        if (RunicClientModels.has((Registry<Enchantment>)reg, RunicClientModels.rl("runic:smelting"), stack)) {
            return idx;
        }
        return 0.0f;
    }

    private static boolean has(Holder<Enchantment> ench, ItemStack stack) {
        return EnchantmentHelper.getItemEnchantmentLevel(ench, (ItemStack)stack) > 0;
    }

    private static boolean has(Registry<Enchantment> reg, ResourceLocation id, ItemStack stack) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id);
        return reg.getHolder(key).map(h -> EnchantmentHelper.getItemEnchantmentLevel((Holder)h, (ItemStack)stack) > 0).orElse(false);
    }

    private static ResourceLocation rl(String s) {
        return ResourceLocation.parse((String)s);
    }
}

