/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.revilodev.runic.item.ModItems;
import net.revilodev.runic.loot.rarity.EnhancementRarities;
import net.revilodev.runic.loot.rarity.EnhancementRarity;

@Mod.EventBusSubscriber(modid="runic")
public final class TestRuneCommand {
    private static final SuggestionProvider<CommandSourceStack> RARITY_SUGGEST = (context, builder) -> {
        EnhancementRarity[] values = EnhancementRarity.values();
        for (int i = 0; i < values.length; ++i) {
            builder.suggest(values[i].key());
        }
        return builder.buildFuture();
    };

    @SubscribeEvent
    public static void onRegister(RegisterCommandsEvent e) {
        CommandDispatcher d = e.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"testrune").requires(src -> src.hasPermission(2))).executes(ctx -> TestRuneCommand.giveRandom((CommandSourceStack)ctx.getSource(), null))).then(Commands.argument((String)"rarity", (ArgumentType)StringArgumentType.word()).suggests(RARITY_SUGGEST).executes(ctx -> TestRuneCommand.giveRandom((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"rarity")))));
    }

    private static int giveRandom(CommandSourceStack src, String rarityStr) {
        List<Holder<Enchantment>> pool;
        EnhancementRarity requested = null;
        if (rarityStr != null && (requested = EnhancementRarity.fromKey(rarityStr.toLowerCase(Locale.ROOT), null)) == null) {
            src.sendSystemMessage((Component)Component.literal((String)("Unknown rarity: " + rarityStr)));
            return 0;
        }
        EnhancementRarity rarityToUse = requested;
        if (rarityToUse == null) {
            EnhancementRarity[] values = EnhancementRarity.values();
            for (int i = 0; i < values.length; ++i) {
                EnhancementRarity r = values[i];
                if (TestRuneCommand.poolFor(r, src).isEmpty()) continue;
                rarityToUse = r;
                break;
            }
            if (rarityToUse == null) {
                src.sendSystemMessage((Component)Component.literal((String)"No enchantments available in the rarity map."));
                return 0;
            }
        }
        if ((pool = TestRuneCommand.poolFor(rarityToUse, src)).isEmpty()) {
            src.sendSystemMessage((Component)Component.literal((String)("No enchantments found for rarity: " + rarityToUse.key())));
            return 0;
        }
        Holder<Enchantment> chosen = pool.get(src.getLevel().getRandom().nextInt(pool.size()));
        ItemStack rune = new ItemStack((ItemLike)ModItems.ENHANCED_RUNE.get());
        ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        mut.set(chosen, 1);
        rune.set(DataComponents.ENCHANTMENTS, (Object)mut.toImmutable());
        try {
            src.getPlayerOrException().addItem(rune);
        }
        catch (Exception ex) {
            src.sendSystemMessage((Component)Component.literal((String)"Must be a player to receive the rune."));
            return 0;
        }
        String chosenId = chosen.unwrapKey().map(k -> k.location().toString()).orElse("unknown");
        src.sendSystemMessage((Component)Component.literal((String)("Gave rune with " + chosenId + " (" + rarityToUse.key() + ")")));
        return 1;
    }

    private static List<Holder<Enchantment>> poolFor(EnhancementRarity target, CommandSourceStack src) {
        ArrayList<Holder<Enchantment>> pool = new ArrayList<Holder<Enchantment>>();
        Registry reg = src.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        for (Map.Entry<ResourceLocation, EnhancementRarity> entry : EnhancementRarities.rawMap().entrySet()) {
            ResourceKey key;
            Optional holder;
            if (entry.getValue() != target || !(holder = reg.getHolder(key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)entry.getKey()))).isPresent()) continue;
            pool.add((Holder<Enchantment>)((Holder)holder.get()));
        }
        return pool;
    }
}

