/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.event;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.revilodev.runic.event.EnchantBlacklist;

@Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class BlacklistStrippingEvents {
    private BlacklistStrippingEvents() {
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemEntity itemEntity = event.getItem();
        ItemStack stack = itemEntity.getItem();
        if (EnchantBlacklist.strip(stack)) {
            itemEntity.setItem(stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.level().isClientSide) {
            return;
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            EnchantBlacklist.strip(stack);
        }
    }
}

