/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.event;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.revilodev.runic.item.ModItems;
import net.revilodev.runic.loot.rarity.EnhancementRarities;
import net.revilodev.runic.loot.rarity.EnhancementRarity;

@Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EnchantTooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemTooltip(ItemTooltipEvent event) {
        boolean recolorRune;
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        boolean isRune = stack.is((Item)ModItems.ENHANCED_RUNE.get());
        ItemEnchantments live = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        boolean recolorGear = !live.isEmpty();
        boolean bl = recolorRune = isRune && (!live.isEmpty() || !stored.isEmpty());
        if (!recolorGear && !recolorRune) {
            return;
        }
        ArrayList<Component> vanillaStrings = new ArrayList<Component>();
        ArrayList<Component> newLines = new ArrayList<Component>();
        if (recolorGear) {
            EnchantTooltipHandler.collectRebuilt(live, vanillaStrings, newLines, isRune);
        }
        if (recolorRune && !stored.isEmpty()) {
            EnchantTooltipHandler.collectRebuilt(stored, vanillaStrings, newLines, isRune);
        }
        if (vanillaStrings.isEmpty()) {
            return;
        }
        List tooltip = event.getToolTip();
        int firstIdx = -1;
        block0: for (int i = tooltip.size() - 1; i >= 0; --i) {
            String s = ((Component)tooltip.get(i)).getString();
            for (Component v : vanillaStrings) {
                if (!s.equals(v.getString())) continue;
                firstIdx = i;
                tooltip.remove(i);
                continue block0;
            }
        }
        int insertAt = firstIdx;
        if (insertAt != -1) {
            tooltip.addAll(insertAt, newLines);
            insertAt += newLines.size();
        }
        if (isRune && (recolorGear || !stored.isEmpty())) {
            EnchantTooltipHandler.appendRuneShiftDescriptions(tooltip, insertAt, live, stored);
        }
    }

    private static void collectRebuilt(ItemEnchantments enchants, List<Component> vanillaOut, List<Component> rebuiltOut, boolean isRune) {
        for (Object2IntMap.Entry e : enchants.entrySet()) {
            Holder holder = (Holder)e.getKey();
            int level = e.getIntValue();
            Enchantment cfr_ignored_0 = (Enchantment)holder.value();
            Component vanilla = Enchantment.getFullname((Holder)holder, (int)level);
            vanillaOut.add(vanilla);
            EnhancementRarity rarity = EnhancementRarities.get((Holder<Enchantment>)holder);
            if (isRune) {
                MutableComponent grayLine = Component.literal((String)vanilla.getString()).withStyle(Style.EMPTY.withColor(0xAAAAAA).withItalic(Boolean.valueOf(false)));
                rebuiltOut.add((Component)grayLine);
                String rarityName = rarity.key().substring(0, 1).toUpperCase() + rarity.key().substring(1);
                MutableComponent rarityLine = Component.literal((String)rarityName).withStyle(st -> st.withColor(rarity.color()).withItalic(Boolean.valueOf(false)));
                rebuiltOut.add((Component)rarityLine);
                continue;
            }
            MutableComponent colored = Component.literal((String)vanilla.getString()).withStyle(st -> st.withColor(rarity.color()).withItalic(Boolean.valueOf(false)));
            rebuiltOut.add((Component)colored);
        }
    }

    private static void appendRuneShiftDescriptions(List<Component> tooltip, int insertAt, ItemEnchantments ... sets) {
        LinkedHashSet keys = new LinkedHashSet();
        for (ItemEnchantments set : sets) {
            for (Object2IntMap.Entry e : set.entrySet()) {
                ((Holder)e.getKey()).unwrapKey().ifPresent(keys::add);
            }
        }
        if (keys.isEmpty()) {
            return;
        }
        boolean shift = Screen.hasShiftDown();
        if (insertAt >= 0 && insertAt <= tooltip.size()) {
            tooltip.add(insertAt, (Component)Component.empty());
            ++insertAt;
        } else {
            tooltip.add((Component)Component.empty());
            insertAt = tooltip.size();
        }
        if (!shift) {
            tooltip.add(insertAt, (Component)Component.literal((String)"Hold \u00a7eShift\u00a7r for details").withStyle(Style.EMPTY.withColor(0x777777).withItalic(Boolean.valueOf(false))));
            return;
        }
        tooltip.add(insertAt++, (Component)Component.literal((String)"Effects").withStyle(Style.EMPTY.withColor(0xBBBBBB).withItalic(Boolean.valueOf(false))));
        for (ResourceKey key : keys) {
            ResourceLocation loc = key.location();
            String langKey = "tooltip.runic." + loc.getPath();
            MutableComponent line = Component.translatable((String)langKey).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)));
            tooltip.add(insertAt++, (Component)line);
        }
    }
}

