/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ItemBlacklistEvents {
    private ItemBlacklistEvents() {
    }

    @SubscribeEvent
    public static void onBuildCreativeContents(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            ItemStack stack = (ItemStack)e.getKey();
            if (!stack.is(Items.ENCHANTED_BOOK) && !stack.is(Items.ENCHANTING_TABLE)) continue;
            it.remove();
        }
    }

    @Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class Villagers {
        private Villagers() {
        }

        @SubscribeEvent
        public static void onVillagerTrades(VillagerTradesEvent event) {
            if (event.getType() == VillagerProfession.LIBRARIAN) {
                Int2ObjectMap trades = event.getTrades();
                for (int level = 5; level == 5; ++level) {
                    List list = (List)trades.get(level);
                    if (list == null) continue;
                    list.clear();
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static final class PickupBlocker {
        private PickupBlocker() {
        }

        @SubscribeEvent
        public static void onItemPickup(EntityItemPickupEvent event) {
            Player player = event.getEntity();
            ItemEntity itemEntity = event.getItem();
            ItemStack stack = itemEntity.getItem();
            if (stack.is(Items.ENCHANTED_BOOK) || stack.is(Items.ENCHANTING_TABLE)) {
                event.setCanceled(true);
                itemEntity.discard();
            }
        }
    }
}

