/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.item.custom;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.revilodev.runic.item.ModItems;

public class RuneItem
extends Item {
    private static final Set<ResourceLocation> BLACKLIST = Set.of(ResourceLocation.parse((String)"minecraft:mending"), ResourceLocation.parse((String)"minecraft:protection"));

    public RuneItem(Item.Properties props) {
        super(props);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private static boolean isBlacklisted(Holder<Enchantment> enchantHolder) {
        return enchantHolder.unwrapKey().map(ResourceKey::location).map(BLACKLIST::contains).orElse(false);
    }

    public static ItemStack createForEnchantment(EnchantmentInstance inst) {
        if (RuneItem.isBlacklisted((Holder<Enchantment>)inst.enchantment)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.ENHANCED_RUNE.get());
        stack.enchant(inst.enchantment, inst.level);
        return stack;
    }
}

