/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.revilodev.runic.RunicMod;
import net.revilodev.runic.item.custom.RuneItem;
import net.revilodev.runic.loot.rarity.EnhancementRarities;
import net.revilodev.runic.loot.rarity.EnhancementRarity;

public class RuneRarityInjector
extends LootModifier {
    public static final MapCodec<RuneRarityInjector> CODEC = RecordCodecBuilder.mapCodec(inst -> RuneRarityInjector.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RuneRarityInjector::new));

    public RuneRarityInjector(LootItemCondition[] conditions) {
        super(conditions);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext ctx) {
        ResourceLocation tableId = ctx.getQueriedLootTableId();
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.THIS_ENTITY);
        RoutesConfig routes = RoutesConfig.get();
        RoutesConfig.Group match = null;
        if (tableId != null && (match = routes.matchTable(tableId)) != null) {
            RunicMod.LOGGER.info("[Runic] Routes: matched group '{}' for table {}", (Object)match.name(), (Object)tableId);
        }
        if (match == null && entity != null && (match = routes.matchEntity(entity)) != null) {
            RunicMod.LOGGER.info("[Runic] Routes: matched group '{}' for entity {}", (Object)match.name(), (Object)entity.getType().builtInRegistryHolder().key().location());
        }
        if (match == null) {
            return generatedLoot;
        }
        RandomSource rand = ctx.getRandom();
        if (rand.nextFloat() > match.baseChance) {
            return generatedLoot;
        }
        EnhancementRarity rarity = match.pickRarity(rand);
        if (rarity == null) {
            return generatedLoot;
        }
        Holder<Enchantment> chosen = this.pickRandomEnchantOf(rarity, rand, (Level)ctx.getLevel());
        if (chosen == null) {
            return generatedLoot;
        }
        ItemStack rune = RuneItem.createForEnchantment(new EnchantmentInstance(chosen, 1));
        if (!rune.isEmpty()) {
            generatedLoot.add((Object)rune);
            RunicMod.LOGGER.info("[Runic] Injected rune with {} (rarity {}) into loot from {}", new Object[]{chosen.unwrapKey().map(k -> k.location().toString()).orElse("unknown"), rarity.key(), tableId != null ? tableId : (entity != null ? entity.getType().builtInRegistryHolder().key().location() : "unknown")});
        } else {
            RunicMod.LOGGER.info("[Runic] Skipped blacklisted enchant {} for rarity {} in {}", new Object[]{chosen.unwrapKey().map(k -> k.location().toString()).orElse("unknown"), rarity.key(), tableId != null ? tableId : (entity != null ? entity.getType().builtInRegistryHolder().key().location() : "unknown")});
        }
        return generatedLoot;
    }

    private Holder<Enchantment> pickRandomEnchantOf(EnhancementRarity target, RandomSource rand, Level level) {
        Registry reg = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        ArrayList pool = new ArrayList();
        for (Map.Entry<ResourceLocation, EnhancementRarity> e : EnhancementRarities.rawMap().entrySet()) {
            if (e.getValue() != target) continue;
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)e.getKey());
            reg.getHolder(key).ifPresent(pool::add);
        }
        if (pool.isEmpty()) {
            return null;
        }
        return (Holder)pool.get(rand.nextInt(pool.size()));
    }

    public static final class RoutesConfig {
        private static RoutesConfig CACHED = null;
        private final List<Group> groups;

        public static RoutesConfig get() {
            if (CACHED == null) {
                CACHED = RoutesConfig.load();
            }
            return CACHED;
        }

        private RoutesConfig(List<Group> groups) {
            this.groups = groups;
        }

        Group matchTable(ResourceLocation tableId) {
            String path = tableId.toString();
            for (Group g : this.groups) {
                for (Pattern p : g.tablePatterns) {
                    if (!p.matcher(path).matches()) continue;
                    return g;
                }
            }
            return null;
        }

        Group matchEntity(Entity entity) {
            String id = entity.getType().builtInRegistryHolder().key().location().toString();
            for (Group g : this.groups) {
                for (Pattern p : g.entityPatterns) {
                    if (!p.matcher(id).matches()) continue;
                    return g;
                }
            }
            return null;
        }

        private static RoutesConfig load() {
            RoutesConfig routesConfig;
            block10: {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                CloseableResourceManager rm = server.getServerResources().resourceManager();
                ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"loot/routes.json");
                Optional opt = rm.getResource(rl);
                if (opt.isEmpty()) {
                    return new RoutesConfig(List.of());
                }
                Resource res = (Resource)opt.get();
                BufferedReader reader = res.openAsReader();
                try {
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append('\n');
                    }
                    routesConfig = RoutesConfig.parse(sb.toString());
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        RunicMod.LOGGER.warn("[Runic] Failed to load routes.json", (Throwable)e);
                        return new RoutesConfig(List.of());
                    }
                }
                reader.close();
            }
            return routesConfig;
        }

        private static RoutesConfig parse(String json) {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            JsonArray arr = root.getAsJsonArray("groups");
            ArrayList<Group> groups = new ArrayList<Group>();
            if (arr != null) {
                for (JsonElement el : arr) {
                    JsonObject g = el.getAsJsonObject();
                    String name = g.get("name").getAsString();
                    ArrayList<Pattern> tablePatterns = new ArrayList<Pattern>();
                    if (g.has("tables")) {
                        for (Object t : g.getAsJsonArray("tables")) {
                            String pat = t.getAsString().replace(".", "\\.").replace("*", ".*");
                            tablePatterns.add(Pattern.compile(pat));
                        }
                    }
                    ArrayList<Pattern> entityPatterns = new ArrayList<Pattern>();
                    if (g.has("entities")) {
                        Object t;
                        t = g.getAsJsonArray("entities").iterator();
                        while (t.hasNext()) {
                            JsonElement e = (JsonElement)t.next();
                            String pat = e.getAsString().replace(".", "\\.").replace("*", ".*");
                            entityPatterns.add(Pattern.compile(pat));
                        }
                    }
                    EnumMap<EnhancementRarity, Integer> weights = new EnumMap<EnhancementRarity, Integer>(EnhancementRarity.class);
                    if (g.has("rarity_weights")) {
                        JsonObject wobj = g.getAsJsonObject("rarity_weights");
                        for (Map.Entry e : wobj.entrySet()) {
                            EnhancementRarity r = EnhancementRarity.fromKey((String)e.getKey(), null);
                            if (r == null) continue;
                            weights.put(r, ((JsonElement)e.getValue()).getAsInt());
                        }
                    }
                    float baseChance = g.has("base_chance") ? g.get("base_chance").getAsFloat() : 0.0f;
                    groups.add(new Group(name, tablePatterns, entityPatterns, weights, baseChance));
                }
            }
            return new RoutesConfig(groups);
        }

        record Group(String name, List<Pattern> tablePatterns, List<Pattern> entityPatterns, Map<EnhancementRarity, Integer> weights, float baseChance) {
            EnhancementRarity pickRarity(RandomSource rand) {
                int total = this.weights.values().stream().mapToInt(Integer::intValue).sum();
                if (total <= 0) {
                    return null;
                }
                int r = rand.nextInt(total);
                for (Map.Entry<EnhancementRarity, Integer> e : this.weights.entrySet()) {
                    if ((r -= e.getValue().intValue()) >= 0) continue;
                    return e.getKey();
                }
                return null;
            }
        }
    }
}

