/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.loot.rarity;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public enum EnhancementRarity {
    COMMON("common", ChatFormatting.GRAY),
    UNCOMMON("uncommon", ChatFormatting.GREEN),
    RARE("rare", ChatFormatting.DARK_AQUA),
    EPIC("epic", ChatFormatting.GOLD),
    LEGENDARY("legendary", ChatFormatting.LIGHT_PURPLE),
    CURSED("cursed", ChatFormatting.DARK_RED);

    private final String key;
    private final ChatFormatting color;

    private EnhancementRarity(String key, ChatFormatting color) {
        this.key = key;
        this.color = color;
    }

    public String key() {
        return this.key;
    }

    public ChatFormatting color() {
        return this.color;
    }

    public Style style() {
        return Style.EMPTY.withColor(this.color);
    }

    public MutableComponent applyTo(Component base) {
        return base.copy().withStyle(this.style());
    }

    public static EnhancementRarity fromKey(String s, EnhancementRarity fallback) {
        if (s == null) {
            return fallback;
        }
        String n = s.trim().toLowerCase();
        for (EnhancementRarity r : EnhancementRarity.values()) {
            if (!r.key.equals(n)) continue;
            return r;
        }
        return fallback;
    }
}

