/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.runes;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.revilodev.runic.runes.RuneSlots;

@Mod.EventBusSubscriber(modid="runic", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RuneSlotTooltipHandler {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        int cap = RuneSlots.capacity(stack);
        if (cap <= 0) {
            return;
        }
        int used = RuneSlots.used(stack);
        int remaining = Math.max(0, cap - used);
        e.getToolTip().add(Component.empty());
        e.getToolTip().add(Component.literal((String)"Rune Slots:").withStyle(ChatFormatting.GRAY));
        e.getToolTip().add(RuneSlots.bar(stack).copy().withStyle(remaining > 0 ? ChatFormatting.GRAY : ChatFormatting.RED));
    }
}

