/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.screen.custom;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.revilodev.runic.block.ModBlocks;
import net.revilodev.runic.item.ModItems;
import net.revilodev.runic.runes.RuneSlots;
import net.revilodev.runic.screen.ModMenuTypes;

public class EtchingTableMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Level level;
    private final SimpleContainer input = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            EtchingTableMenu.this.slotsChanged((Container)this);
        }

        public int getMaxStackSize() {
            return 1;
        }
    };
    private final ResultContainer result = new ResultContainer();

    private EtchingTableMenu(int id, Inventory playerInv, ContainerLevelAccess access) {
        super((MenuType)ModMenuTypes.ETCHING_TABLE.get(), id);
        int c;
        this.access = access;
        this.level = playerInv.player.level();
        this.addSlot(new Slot((Container)this.input, 0, 8, 50));
        this.addSlot(new Slot((Container)this.input, 1, 44, 50));
        this.addSlot(new Slot((Container)this.result, 0, 98, 50){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                return !this.getItem().isEmpty();
            }

            public void onTake(Player player, ItemStack taken) {
                if (!RuneSlots.tryConsumeSlot(taken)) {
                    player.displayClientMessage((Component)Component.literal((String)"No rune slots remaining!").withStyle(ChatFormatting.RED), true);
                } else {
                    EtchingTableMenu.this.consumeInputs();
                    EtchingTableMenu.this.access.execute((lvl, pos) -> lvl.playSound(null, pos, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f));
                }
                EtchingTableMenu.this.result.setItem(0, ItemStack.EMPTY);
                EtchingTableMenu.this.updateResult();
                super.onTake(player, taken);
            }
        });
        int invX = 8;
        int invY = 84;
        for (int r = 0; r < 3; ++r) {
            for (c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)playerInv, c + r * 9 + 9, 8 + c * 18, 84 + r * 18));
            }
        }
        int hotbarY = 142;
        for (c = 0; c < 9; ++c) {
            this.addSlot(new Slot((Container)playerInv, c, 8 + c * 18, 142));
        }
        this.updateResult();
    }

    public static EtchingTableMenu server(int id, Inventory inv, Level level, BlockPos pos) {
        return new EtchingTableMenu(id, inv, ContainerLevelAccess.create((Level)level, (BlockPos)pos));
    }

    public static EtchingTableMenu client(int id, Inventory inv, BlockPos pos) {
        return new EtchingTableMenu(id, inv, ContainerLevelAccess.create((Level)inv.player.level(), (BlockPos)pos));
    }

    public void slotsChanged(Container container) {
        this.updateResult();
    }

    private void updateResult() {
        ItemStack target = this.input.getItem(0);
        ItemStack rune = this.input.getItem(1);
        ItemStack out = this.computeResult(target, rune);
        this.result.setItem(0, out);
        this.broadcastChanges();
    }

    private void consumeInputs() {
        ItemStack t = this.input.getItem(0);
        ItemStack r = this.input.getItem(1);
        if (!t.isEmpty()) {
            t.shrink(1);
        }
        if (!r.isEmpty()) {
            r.shrink(1);
        }
        this.input.setChanged();
    }

    private ItemStack computeResult(ItemStack target, ItemStack rune) {
        Iterator iterator;
        if (target.isEmpty() || rune.isEmpty() || !rune.is((Item)ModItems.ENHANCED_RUNE.get())) {
            return ItemStack.EMPTY;
        }
        if (RuneSlots.remaining(target) <= 0) {
            return ItemStack.EMPTY;
        }
        Holder ench = null;
        int lvlVal = 0;
        ItemEnchantments stored = (ItemEnchantments)rune.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments direct = (ItemEnchantments)rune.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (!stored.isEmpty()) {
            iterator = stored.entrySet().iterator();
            if (iterator.hasNext()) {
                e = (Object2IntMap.Entry)iterator.next();
                ench = (Holder)e.getKey();
                lvlVal = e.getIntValue();
            }
        } else if (!direct.isEmpty() && (iterator = direct.entrySet().iterator()).hasNext()) {
            e = (Object2IntMap.Entry)iterator.next();
            ench = (Holder)e.getKey();
            lvlVal = e.getIntValue();
        }
        if (ench == null || lvlVal <= 0) {
            return ItemStack.EMPTY;
        }
        ItemStack out = target.copy();
        if (!EtchingTableMenu.isCompatibleWithExisting(out, ench)) {
            return ItemStack.EMPTY;
        }
        if (!EtchingTableMenu.canApplyToTarget(out, (Holder<Enchantment>)ench)) {
            return ItemStack.EMPTY;
        }
        int max = ((Enchantment)ench.value()).getMaxLevel();
        int applyLevel = Math.min(lvlVal, max);
        ItemEnchantments existing = (ItemEnchantments)out.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(existing);
        mut.set(ench, applyLevel);
        out.set(DataComponents.ENCHANTMENTS, (Object)mut.toImmutable());
        return out;
    }

    public void removed(Player player) {
        super.removed(player);
        this.access.execute((lvl, pos) -> this.clearContainer(player, (Container)this.input));
        this.result.removeItemNoUpdate(0);
    }

    public boolean stillValid(Player player) {
        return EtchingTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.ETCHING_TABLE.get()));
    }

    public ItemStack getPreviewStack() {
        return this.input.getItem(0);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        ItemStack originalCopy = stackInSlot.copy();
        int RESULT_IDX = 2;
        int INV_START = 3;
        int INV_END = 30;
        int HOTBAR_START = 30;
        int HOTBAR_END = 39;
        if (index == 2) {
            if (!RuneSlots.tryConsumeSlot(stackInSlot)) {
                return ItemStack.EMPTY;
            }
            this.consumeInputs();
            this.access.execute((lvl, pos) -> lvl.playSound(null, pos, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f));
            if (!this.moveItemStackTo(stackInSlot, 3, 39, true)) {
                return ItemStack.EMPTY;
            }
            slot.set(ItemStack.EMPTY);
            this.result.setItem(0, ItemStack.EMPTY);
            this.updateResult();
            return originalCopy;
        }
        if (index < 3 ? !this.moveItemStackTo(stackInSlot, 3, 39, false) : (stackInSlot.is((Item)ModItems.ENHANCED_RUNE.get()) ? !this.moveItemStackTo(stackInSlot, 1, 2, false) : !this.moveItemStackTo(stackInSlot, 0, 1, false))) {
            return ItemStack.EMPTY;
        }
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stackInSlot.getCount() == originalCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        return originalCopy;
    }

    private static boolean canApplyToTarget(ItemStack target, Holder<Enchantment> newEnch) {
        return ((Enchantment)newEnch.value()).canEnchant(target);
    }

    private static boolean isCompatibleWithExisting(ItemStack stack, Holder<Enchantment> newEnch) {
        ItemEnchantments existing = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry e : existing.entrySet()) {
            if (Enchantment.areCompatible((Holder)((Holder)e.getKey()), newEnch)) continue;
            return false;
        }
        return true;
    }
}

