/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.Enhancements.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import net.revilodev.runic.effect.ModMobEffects;

public record StunningAspect() implements EnchantmentEntityEffect
{
    public static final MapCodec<StunningAspect> CODEC = MapCodec.unit(StunningAspect::new);

    public void apply(ServerLevel level, int enchantLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        float chance;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        RandomSource random = level.getRandom();
        switch (enchantLevel) {
            case 1: {
                float f = 0.05f;
                break;
            }
            case 2: {
                float f = 0.07f;
                break;
            }
            default: {
                float f = chance = 0.1f;
            }
        }
        if (random.nextFloat() < chance) {
            int duration = switch (enchantLevel) {
                case 1 -> 20;
                case 2 -> 40;
                default -> 50;
            };
            int amplifier = enchantLevel - 1;
            Holder.Reference holder = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT).getHolderOrThrow(ModMobEffects.STUNNING.getKey());
            living.addEffect(new MobEffectInstance((Holder)holder, duration, amplifier, false, false, true));
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

