/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.client;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.revilodev.runic.item.ModItems;

public final class RunicClientModels {
    private RunicClientModels() {
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"runic", (String)path);
    }

    public static void init() {
        ItemProperties.register((Item)((Item)ModItems.ENHANCED_RUNE.get()), (ResourceLocation)RunicClientModels.id("rune_model"), RunicClientModels::runePredicate);
    }

    private static float runePredicate(ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
        if (stack.isEmpty()) {
            return 0.0f;
        }
        ItemEnchantments enchants = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (enchants.isEmpty()) {
            enchants = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        }
        if (enchants.isEmpty()) {
            return 0.0f;
        }
        Iterator iterator = enchants.entrySet().iterator();
        if (iterator.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
            Holder ench = (Holder)entry.getKey();
            String path = ench.unwrapKey().map(k -> k.location().getPath()).orElse("");
            return RunicClientModels.mapEnchantToIndex(path);
        }
        return 0.0f;
    }

    private static float mapEnchantToIndex(String path) {
        return switch (path) {
            case "protection" -> 1.0f;
            case "fire_protection" -> 2.0f;
            case "blast_protection" -> 3.0f;
            case "projectile_protection" -> 4.0f;
            case "thorns" -> 5.0f;
            case "respiration" -> 6.0f;
            case "aqua_affinity" -> 7.0f;
            case "depth_strider" -> 8.0f;
            case "frost_walker" -> 9.0f;
            case "soul_speed" -> 10.0f;
            case "feather_falling" -> 11.0f;
            case "sharpness" -> 12.0f;
            case "smite" -> 13.0f;
            case "bane_of_arthropods" -> 14.0f;
            case "knockback" -> 15.0f;
            case "fire_aspect" -> 16.0f;
            case "looting" -> 17.0f;
            case "sweeping_edge" -> 18.0f;
            case "lightning_aspect" -> 19.0f;
            case "poison_aspect" -> 20.0f;
            case "slowness_aspect" -> 21.0f;
            case "weakness_aspect" -> 22.0f;
            case "swift_strike" -> 23.0f;
            case "efficiency" -> 24.0f;
            case "silk_touch" -> 25.0f;
            case "fortune" -> 26.0f;
            case "unbreaking" -> 27.0f;
            case "mending" -> 28.0f;
            case "vanishing_curse" -> 29.0f;
            case "binding_curse" -> 30.0f;
            case "power" -> 31.0f;
            case "punch" -> 32.0f;
            case "flame" -> 33.0f;
            case "infinity" -> 34.0f;
            case "multishot" -> 35.0f;
            case "piercing" -> 36.0f;
            case "quick_charge" -> 37.0f;
            case "impaling" -> 38.0f;
            case "riptide" -> 39.0f;
            case "loyalty" -> 40.0f;
            case "channeling" -> 41.0f;
            case "luck_of_the_sea" -> 42.0f;
            case "lure" -> 43.0f;
            case "breach" -> 44.0f;
            case "density" -> 45.0f;
            case "wind_burst" -> 46.0f;
            case "swift_sneak" -> 47.0f;
            case "swift" -> 48.0f;
            case "smelting" -> 49.0f;
            case "sculk_smite" -> 50.0f;
            case "capacity" -> 51.0f;
            case "soul_siphoner" -> 52.0f;
            case "fire_react" -> 53.0f;
            case "catalysis" -> 54.0f;
            case "destruction" -> 55.0f;
            case "mystical_enlightenment" -> 56.0f;
            case "renewal" -> 57.0f;
            case "chill_aura" -> 58.0f;
            case "potato_recovery" -> 59.0f;
            case "acrobat" -> 60.0f;
            case "longfooted" -> 61.0f;
            case "multi_roll" -> 62.0f;
            case "bleeding_aspect" -> 63.0f;
            case "stunning_aspect" -> 64.0f;
            case "soulbound" -> 65.0f;
            case "wither_aspect" -> 66.0f;
            case "mandela_aspect" -> 67.0f;
            case "vitality" -> 68.0f;
            case "leaping" -> 69.0f;
            case "reach" -> 70.0f;
            case "buzzing_aspect" -> 71.0f;
            case "toughness" -> 72.0f;
            case "curse_of_unluck" -> 73.0f;
            default -> 0.0f;
        };
    }
}

