/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.revilodev.runic.datagen.ModBlockLootTableProvider;
import net.revilodev.runic.datagen.ModBlockTagProvider;
import net.revilodev.runic.datagen.ModDatapackEntries;
import net.revilodev.runic.datagen.ModGLMProvider;
import net.revilodev.runic.datagen.ModItemModelProvider;

@EventBusSubscriber(modid="runic", bus=EventBusSubscriber.Bus.MOD)
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
            generator.addProvider(true, (DataProvider)new ModDatapackEntries(output, lookupProvider));
            generator.addProvider(true, (DataProvider)new ModGLMProvider(output, lookupProvider));
            ModBlockTagProvider blockTags = new ModBlockTagProvider(output, lookupProvider, fileHelper);
            generator.addProvider(true, (DataProvider)blockTags);
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ModItemModelProvider(output, fileHelper));
        }
    }
}

