/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.effect;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class StunningMobEffect
extends MobEffect {
    public StunningMobEffect() {
        super(MobEffectCategory.HARMFUL, 0xE6E600);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"stun_speed"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        entity.setJumping(false);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            double radius = 0.6;
            int tick = entity.tickCount;
            for (int i = 0; i < 3; ++i) {
                double angleDeg = (double)tick * 0.3 + (double)(i * 120);
                double angle = angleDeg * (Math.PI / 180);
                double x = entity.getX() + radius * Math.cos(angle);
                double z = entity.getZ() + radius * Math.sin(angle);
                double d = entity.getY() + (double)entity.getBbHeight() + 0.4;
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int tickCount, int amplifier) {
        return true;
    }
}

