/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.event;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public final class EnchantBlacklist {
    private static final Set<ResourceLocation> IDS = Set.of(ResourceLocation.parse((String)"minecraft:mending"), ResourceLocation.parse((String)"minecraft:protection"), ResourceLocation.parse((String)"minecraft:bane_of_arthropods"));

    private EnchantBlacklist() {
    }

    public static boolean isBlacklisted(Holder<Enchantment> h) {
        return h.unwrapKey().map(ResourceKey::location).map(IDS::contains).orElse(false);
    }

    public static boolean strip(ItemStack stack) {
        ItemEnchantments stored;
        boolean changed = false;
        ItemEnchantments cur = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (!cur.isEmpty()) {
            ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(cur);
            cur.entrySet().forEach(e -> {
                if (EnchantBlacklist.isBlacklisted((Holder<Enchantment>)((Holder)e.getKey()))) {
                    mut.set((Holder)e.getKey(), 0);
                }
            });
            ItemEnchantments cleaned = mut.toImmutable();
            if (!cleaned.equals((Object)cur)) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)cleaned);
                changed = true;
            }
        }
        if (!(stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()) {
            ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(stored);
            stored.entrySet().forEach(e -> {
                if (EnchantBlacklist.isBlacklisted((Holder<Enchantment>)((Holder)e.getKey()))) {
                    mut.set((Holder)e.getKey(), 0);
                }
            });
            ItemEnchantments cleaned = mut.toImmutable();
            if (!cleaned.equals((Object)stored)) {
                stack.set(DataComponents.STORED_ENCHANTMENTS, (Object)cleaned);
                changed = true;
            }
        }
        return changed;
    }
}

