/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="runic")
public final class ItemBlacklistEvents {
    private ItemBlacklistEvents() {
    }

    @SubscribeEvent
    public static void onItemPickup(ItemEntityPickupEvent.Pre event) {
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack stack = itemEntity.getItem();
        if (stack.is(Items.ENCHANTED_BOOK) || stack.is(Items.ENCHANTING_TABLE)) {
            itemEntity.discard();
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades;
        List master;
        if (event.getType() == VillagerProfession.LIBRARIAN && (master = (List)(trades = event.getTrades()).get(5)) != null) {
            master.clear();
        }
    }

    @SubscribeEvent
    public static void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().forEach(ench -> {
                Enchantment e = (Enchantment)ench.value();
                for (int lvl = e.getMinLevel(); lvl <= e.getMaxLevel(); ++lvl) {
                    ItemStack book = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)ench, lvl));
                    event.remove(book, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            });
        }
        event.remove(new ItemStack((ItemLike)Items.ENCHANTING_TABLE), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

