/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.item.custom;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.revilodev.runic.RunicMod;
import net.revilodev.runic.item.ModItems;

public class RuneItem
extends Item {
    private static final Set<ResourceLocation> BLACKLIST = Set.of(ResourceLocation.withDefaultNamespace((String)"mending"), ResourceLocation.withDefaultNamespace((String)"protection"));

    public RuneItem(Item.Properties props) {
        super(props);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private static boolean isBlacklisted(Holder<Enchantment> enchantHolder) {
        return enchantHolder.unwrapKey().map(k -> BLACKLIST.contains(k.location())).orElse(false);
    }

    public static ItemStack createForEnchantment(EnchantmentInstance inst) {
        if (RuneItem.isBlacklisted((Holder<Enchantment>)inst.enchantment)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.ENHANCED_RUNE.value());
        stack.enchant(inst.enchantment, inst.level);
        return stack;
    }

    public static ResourceLocation getRuneTexture(ItemStack stack) {
        ItemEnchantments enchants;
        ResourceLocation base = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"item/rune/enhanced_rune");
        ItemEnchantments stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments direct = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments itemEnchantments = enchants = !stored.isEmpty() ? stored : direct;
        if (enchants.isEmpty()) {
            RunicMod.LOGGER.debug("[Runic] No enchantments found on rune: {}", (Object)stack);
            return base;
        }
        Holder ench = (Holder)enchants.keySet().iterator().next();
        return ench.unwrapKey().map(k -> {
            ResourceLocation tex = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)("item/rune/" + k.location().getNamespace() + "/" + k.location().getPath()));
            RunicMod.LOGGER.debug("[Runic] Resolved rune texture for {} \u2192 {}", (Object)k.location(), (Object)tex);
            return tex;
        }).orElseGet(() -> {
            RunicMod.LOGGER.warn("[Runic] Could not resolve key for enchant on rune: {}", (Object)stack);
            return base;
        });
    }
}

