/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.revilodev.runic.RunicMod;

public class EnchantInjector
extends LootModifier {
    public static final MapCodec<EnchantInjector> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ResourceLocation.CODEC.listOf().fieldOf("enchants").forGetter(m -> m.enchantIds)).and((App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(0.25f)).forGetter(m -> Float.valueOf(m.chance))).and((App)Codec.INT.fieldOf("min_level").orElse((Object)1).forGetter(m -> m.minLevel)).and((App)Codec.INT.fieldOf("max_level").orElse((Object)2).forGetter(m -> m.maxLevel)).and((App)Codec.BOOL.fieldOf("only_vanilla").orElse((Object)true).forGetter(m -> m.onlyVanilla)).apply((Applicative)inst, EnchantInjector::new));
    private final List<ResourceLocation> enchantIds;
    private final float chance;
    private final int minLevel;
    private final int maxLevel;
    private final boolean onlyVanilla;

    public EnchantInjector(LootItemCondition[] conditions, List<ResourceLocation> enchantIds, float chance, int minLevel, int maxLevel, boolean onlyVanilla) {
        super(conditions);
        this.enchantIds = new ArrayList<ResourceLocation>(enchantIds);
        this.chance = chance;
        this.minLevel = Math.max(1, minLevel);
        this.maxLevel = Math.max(this.minLevel, maxLevel);
        this.onlyVanilla = onlyVanilla;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generated, LootContext ctx) {
        ServerLevel serverLevel = ctx.getLevel();
        if (!(serverLevel instanceof ServerLevel)) {
            return generated;
        }
        ServerLevel level = serverLevel;
        RandomSource rng = level.getRandom();
        HolderLookup.RegistryLookup enchRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ObjectArrayList out = new ObjectArrayList(generated.size());
        for (ItemStack stack : generated) {
            if (stack.is(Items.ENCHANTED_BOOK)) {
                out.add((Object)stack);
                continue;
            }
            if (this.onlyVanilla && !"minecraft".equals(stack.getItem().builtInRegistryHolder().key().location().getNamespace())) {
                out.add((Object)stack);
                continue;
            }
            ItemEnchantments current = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(current);
            boolean changed = false;
            for (ResourceLocation id : this.enchantIds) {
                Holder ench;
                Optional opt = enchRegistry.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)id));
                if (opt.isEmpty() || !((Enchantment)(ench = (Holder)opt.get()).value()).canEnchant(stack) || !(rng.nextFloat() < this.chance)) continue;
                int rolled = rng.nextIntBetweenInclusive(this.minLevel, this.maxLevel);
                int levelClamped = Mth.clamp((int)rolled, (int)1, (int)((Enchantment)ench.value()).getMaxLevel());
                if (mut.getLevel(ench) >= levelClamped) continue;
                mut.set(ench, levelClamped);
                changed = true;
                RunicMod.LOGGER.debug("[EnchantInjector] Applied {} lvl {} to {}", new Object[]{id, levelClamped, stack.getHoverName().getString()});
            }
            if (changed) {
                stack.set(DataComponents.ENCHANTMENTS, (Object)mut.toImmutable());
            }
            out.add((Object)stack);
        }
        return out;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

