/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.loot.rarity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.revilodev.runic.loot.rarity.EnhancementRarities;
import net.revilodev.runic.loot.rarity.EnhancementRarity;

public class EnhancementRarityClientReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    public static final String FOLDER = "rarities";

    public EnhancementRarityClientReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager rm, ProfilerFiller profiler) {
        EnhancementRarities.clear();
        for (Map.Entry<ResourceLocation, JsonElement> e : objects.entrySet()) {
            JsonObject root = e.getValue().getAsJsonObject();
            String def = GsonHelper.getAsString((JsonObject)root, (String)"default", null);
            if (def != null) {
                EnhancementRarities.setDefault(EnhancementRarity.fromKey(def, EnhancementRarity.COMMON));
            }
            if (!root.has("entries")) continue;
            JsonObject obj = root.getAsJsonObject("entries");
            for (Map.Entry ent : obj.entrySet()) {
                try {
                    ResourceLocation id = ResourceLocation.parse((String)((String)ent.getKey()));
                    EnhancementRarity rar = EnhancementRarity.fromKey(GsonHelper.convertToString((JsonElement)((JsonElement)ent.getValue()), (String)"rarity"), null);
                    if (rar == null) continue;
                    EnhancementRarities.put(id, rar);
                }
                catch (Exception exception) {}
            }
        }
    }
}

