/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.runes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.revilodev.runic.RunicMod;

public final class RuneSlotCapacityData
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String FOLDER = "rune_slots";
    private static Map<Item, Integer> CAPACITIES = new HashMap<Item, Integer>();
    private static Map<String, Integer> DEFAULTS = new HashMap<String, Integer>();

    public RuneSlotCapacityData() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<Item, Integer> fresh = new HashMap<Item, Integer>();
        HashMap<String, Integer> defaults = new HashMap<String, Integer>();
        objects.forEach((rl, element) -> {
            if (!element.isJsonObject()) {
                RunicMod.LOGGER.warn("RuneSlots: {} is not a JSON object", rl);
                return;
            }
            JsonObject json = element.getAsJsonObject();
            if (json.has("defaults") && json.get("defaults").isJsonObject()) {
                JsonObject defs = json.getAsJsonObject("defaults");
                for (String keyStr : defs.keySet()) {
                    int slots = GsonHelper.getAsInt((JsonObject)defs, (String)keyStr, (int)0);
                    defaults.put(keyStr, Math.max(0, slots));
                }
                return;
            }
            if (json.has("items") && json.get("items").isJsonObject()) {
                JsonObject items = json.getAsJsonObject("items");
                for (String keyStr : items.keySet()) {
                    ResourceLocation key = ResourceLocation.tryParse((String)keyStr);
                    if (key == null) {
                        RunicMod.LOGGER.warn("RuneSlots: invalid item id '{}' in {}", (Object)keyStr, rl);
                        continue;
                    }
                    int slots = GsonHelper.getAsInt((JsonObject)items, (String)keyStr, (int)0);
                    RuneSlotCapacityData.putSafe(fresh, key, slots, rl);
                }
                return;
            }
            if (json.has("list") && json.get("list").isJsonArray()) {
                json.getAsJsonArray("list").forEach(el -> {
                    if (!el.isJsonObject()) {
                        return;
                    }
                    JsonObject entry = el.getAsJsonObject();
                    String itemId = GsonHelper.getAsString((JsonObject)entry, (String)"item", (String)"");
                    int slots = GsonHelper.getAsInt((JsonObject)entry, (String)"slots", (int)0);
                    ResourceLocation key = ResourceLocation.tryParse((String)itemId);
                    if (key == null) {
                        RunicMod.LOGGER.warn("RuneSlots: invalid item id '{}' in {}", (Object)itemId, rl);
                        return;
                    }
                    RuneSlotCapacityData.putSafe(fresh, key, slots, rl);
                });
                return;
            }
            String itemId = GsonHelper.getAsString((JsonObject)json, (String)"item", (String)"");
            int slots = GsonHelper.getAsInt((JsonObject)json, (String)"slots", (int)0);
            ResourceLocation key = ResourceLocation.tryParse((String)itemId);
            if (key == null) {
                RunicMod.LOGGER.warn("RuneSlots: invalid item id '{}' in {}", (Object)itemId, rl);
                return;
            }
            RuneSlotCapacityData.putSafe(fresh, key, slots, rl);
        });
        CAPACITIES = fresh;
        DEFAULTS = defaults;
        RunicMod.LOGGER.info("Loaded {} rune slot capacity entries and {} defaults.", (Object)CAPACITIES.size(), (Object)DEFAULTS.size());
    }

    private static void putSafe(Map<Item, Integer> map, ResourceLocation itemId, int slots, ResourceLocation source) {
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        if (item == null) {
            RunicMod.LOGGER.warn("RuneSlots: unknown item '{}' in {}", (Object)itemId, (Object)source);
            return;
        }
        map.put(item, Math.max(0, slots));
    }

    public static int capacity(Item item) {
        Integer direct = CAPACITIES.get(item);
        if (direct != null) {
            return direct;
        }
        String type = RuneSlotCapacityData.classify(item);
        if (type != null && DEFAULTS.containsKey(type)) {
            return DEFAULTS.get(type);
        }
        return 0;
    }

    private static String classify(Item item) {
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            return switch (armor.getType()) {
                case ArmorItem.Type.HELMET -> "helmet";
                case ArmorItem.Type.CHESTPLATE -> "chestplate";
                case ArmorItem.Type.LEGGINGS -> "leggings";
                case ArmorItem.Type.BOOTS -> "boots";
                default -> null;
            };
        }
        if (item instanceof SwordItem) {
            return "sword";
        }
        if (item instanceof PickaxeItem) {
            return "pickaxe";
        }
        if (item instanceof AxeItem) {
            return "axe";
        }
        if (item instanceof ShovelItem) {
            return "shovel";
        }
        if (item instanceof HoeItem) {
            return "hoe";
        }
        if (item instanceof BowItem) {
            return "bow";
        }
        if (item instanceof CrossbowItem) {
            return "crossbow";
        }
        if (item instanceof ShieldItem) {
            return "shield";
        }
        if (item instanceof TridentItem) {
            return "trident";
        }
        if (item instanceof ElytraItem) {
            return "elytra";
        }
        if (item instanceof FishingRodItem) {
            return "fishing_rod";
        }
        return null;
    }
}

