/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.runes;

import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.revilodev.runic.registry.ModDataComponents;
import net.revilodev.runic.runes.RuneSlotCapacityData;

public final class RuneSlots {
    public static int capacity(ItemStack stack) {
        Item item = stack.getItem();
        return RuneSlotCapacityData.capacity(item);
    }

    public static int used(ItemStack stack) {
        Integer v = (Integer)stack.get((DataComponentType)ModDataComponents.RUNE_SLOTS_USED.get());
        return v == null ? 0 : Math.max(0, v);
    }

    public static int remaining(ItemStack stack) {
        int cap = RuneSlots.capacity(stack);
        return Math.max(0, cap - RuneSlots.used(stack));
    }

    public static boolean tryConsumeSlot(ItemStack stack) {
        int cap = RuneSlots.capacity(stack);
        if (cap <= 0) {
            return false;
        }
        int u = RuneSlots.used(stack);
        if (u >= cap) {
            return false;
        }
        stack.set((DataComponentType)ModDataComponents.RUNE_SLOTS_USED.get(), (Object)(u + 1));
        return true;
    }

    public static void refundOne(ItemStack stack) {
        int u = RuneSlots.used(stack);
        if (u > 0) {
            stack.set((DataComponentType)ModDataComponents.RUNE_SLOTS_USED.get(), (Object)(u - 1));
        }
    }

    public static Component bar(ItemStack stack) {
        int i;
        int cap = RuneSlots.capacity(stack);
        int u = RuneSlots.used(stack);
        if (cap <= 0) {
            return Component.literal((String)"No rune slots").withStyle(ChatFormatting.DARK_GRAY);
        }
        int rem = Math.max(0, cap - u);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < u; ++i) {
            sb.append('\u2b24');
        }
        for (i = 0; i < rem; ++i) {
            sb.append('\u25ef');
        }
        return Component.literal((String)sb.toString()).withStyle(ChatFormatting.AQUA);
    }

    private RuneSlots() {
    }
}

