/*
 * Decompiled with CFR 0.152.
 */
package net.revilodev.runic.screen.custom;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.revilodev.runic.client.EtchingPreviewRenderer;
import net.revilodev.runic.screen.custom.EtchingTableMenu;

public class EtchingTableScreen
extends AbstractContainerScreen<EtchingTableMenu> {
    private static final ResourceLocation TEX = ResourceLocation.fromNamespaceAndPath((String)"runic", (String)"textures/gui/container/etching_table.png");
    private static final int PREVIEW_X = 116;
    private static final int PREVIEW_Y = 16;
    private static final int PREVIEW_W = 52;
    private static final int PREVIEW_H = 52;

    public EtchingTableScreen(EtchingTableMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.titleLabelX = 40;
        this.titleLabelY = 20;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    protected void renderBg(GuiGraphics gg, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        gg.blit(TEX, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 166);
        ItemStack toPreview = ((EtchingTableMenu)this.menu).getSlot(2).getItem();
        if (!toPreview.isEmpty()) {
            EtchingPreviewRenderer.render(gg, toPreview, x + 116, y + 16, 52, 52, partialTick);
        }
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(gg, mouseX, mouseY, partialTick);
        super.render(gg, mouseX, mouseY, partialTick);
        this.renderTooltip(gg, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics gg, int mouseX, int mouseY) {
        gg.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        gg.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }
}

