/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer;

import com.mojang.logging.LogUtils;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.sync.ComponentPacketWriter;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import gravity_changer.EntityTags;
import gravity_changer.GravityChangerComponents;
import gravity_changer.GravityChangerMod;
import gravity_changer.RotationAnimation;
import gravity_changer.api.GravityChangerAPI;
import gravity_changer.api.RotationParameters;
import gravity_changer.mixin.EntityAccessor;
import gravity_changer.util.GCUtil;
import gravity_changer.util.RotationUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_265;
import net.minecraft.class_4048;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class GravityComponent
implements Component,
AutoSyncedComponent,
CommonTickingComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<GravityUpdateCallback> GRAVITY_UPDATE_EVENT = EventFactory.createArrayBacked(GravityUpdateCallback.class, listeners -> (entity, component) -> {
        for (GravityUpdateCallback callback : listeners) {
            callback.update(entity, component);
        }
    });
    private boolean initialized = false;
    private class_2350 prevGravityDirection = class_2350.field_11033;
    private double prevGravityStrength = 1.0;
    class_2350 baseGravityDirection = class_2350.field_11033;
    double baseGravityStrength = 1.0;
    @Nullable
    RotationParameters currentRotationParameters = RotationParameters.getDefault();
    @Nullable
    public final RotationAnimation animation;
    public final class_1297 entity;
    private class_2350 currGravityDirection = class_2350.field_11033;
    private double currGravityStrength = 1.0;
    private double currentEffectPriority = Double.MIN_VALUE;
    private boolean isFiringUpdateEvent = false;
    @Nullable
    private GravityDirEffect delayApplyDirEffect = null;
    private double delayApplyStrengthEffect = 1.0;
    private long lastUpdateTickCount = 0L;
    private boolean needsSync = false;

    public GravityComponent(class_1297 entity) {
        this.entity = entity;
        this.animation = entity.method_37908().method_8608() ? new RotationAnimation() : null;
    }

    public void readFromNbt(class_2487 tag) {
        this.baseGravityDirection = tag.method_10545("baseGravityDirection") ? class_2350.method_10168((String)tag.method_10558("baseGravityDirection")) : class_2350.field_11033;
        this.baseGravityStrength = tag.method_10545("baseGravityStrength") ? tag.method_10574("baseGravityStrength") : 1.0;
        if (!this.initialized || this.shouldAcceptServerSync()) {
            this.currGravityDirection = tag.method_10545("currentGravityDirection") ? class_2350.method_10168((String)tag.method_10558("currentGravityDirection")) : class_2350.field_11033;
            this.currGravityStrength = tag.method_10545("currentGravityStrength") ? tag.method_10574("currentGravityStrength") : 1.0;
        }
        if (!this.initialized) {
            this.prevGravityDirection = this.currGravityDirection;
            this.prevGravityStrength = this.currGravityStrength;
            this.initialized = true;
            this.applyGravityDirectionChange(this.prevGravityDirection, this.currGravityDirection, this.currentRotationParameters, true);
        }
    }

    private boolean shouldAcceptServerSync() {
        return this.entity.method_37908().method_8608() && !GCUtil.isClientPlayer(this.entity);
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        tag.method_10582("baseGravityDirection", this.baseGravityDirection.method_10151());
        tag.method_10582("currentGravityDirection", this.currGravityDirection.method_10151());
        tag.method_10549("baseGravityStrength", this.baseGravityStrength);
        tag.method_10549("currentGravityStrength", this.currGravityStrength);
    }

    public void tick() {
        if (!this.canChangeGravity()) {
            return;
        }
        this.updateGravityStatus(true);
        this.applyGravityChange();
        if (!this.entity.method_37908().method_8608() && this.needsSync) {
            this.needsSync = false;
            GravityChangerComponents.GRAVITY_COMP_KEY.sync((Object)this.entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGravityStatus(boolean sendPacketIfNecessary) {
        if (this.shouldAcceptServerSync()) {
            return;
        }
        class_2350 oldGravityDirection = this.currGravityDirection;
        double oldGravityStrength = this.currGravityStrength;
        class_1297 vehicle = this.entity.method_5854();
        if (vehicle != null) {
            this.currGravityDirection = GravityChangerAPI.getGravityDirection(vehicle);
            this.currGravityStrength = GravityChangerAPI.getGravityStrength(vehicle);
        } else {
            this.currGravityDirection = this.baseGravityDirection;
            this.currGravityStrength = this.baseGravityStrength;
            this.currGravityStrength *= GravityChangerAPI.getDimensionGravityStrength(this.entity.method_37908());
            this.currGravityStrength *= GravityChangerMod.config.gravityStrengthMultiplier;
            this.currentEffectPriority = Double.MIN_VALUE;
            this.isFiringUpdateEvent = true;
            try {
                ((GravityUpdateCallback)GRAVITY_UPDATE_EVENT.invoker()).update(this.entity, this);
                if (this.delayApplyDirEffect != null) {
                    this.applyGravityDirectionEffect(this.delayApplyDirEffect.direction(), this.delayApplyDirEffect.rotationParameters(), this.delayApplyDirEffect.priority());
                    this.delayApplyDirEffect = null;
                }
                this.currGravityStrength *= this.delayApplyStrengthEffect;
                this.delayApplyStrengthEffect = 1.0;
            }
            finally {
                this.isFiringUpdateEvent = false;
            }
            if (this.currentEffectPriority == Double.MIN_VALUE) {
                this.currentRotationParameters = RotationParameters.getDefault();
            }
            this.lastUpdateTickCount = this.entity.field_6012;
        }
        if (sendPacketIfNecessary) {
            boolean changed;
            boolean bl = changed = oldGravityDirection != this.currGravityDirection || Math.abs(oldGravityStrength - this.currGravityStrength) > 1.0E-4;
            if (changed) {
                this.sendSyncPacketToOtherPlayers();
            }
        }
    }

    private void sendSyncPacketToOtherPlayers() {
        GravityChangerComponents.GRAVITY_COMP_KEY.sync((Object)this.entity, (ComponentPacketWriter)this, p -> p != this.entity);
    }

    public void applyGravityDirectionEffect(@NotNull class_2350 direction, @Nullable RotationParameters rotationParameters, double priority) {
        if (this.isFiringUpdateEvent) {
            if (priority > this.currentEffectPriority) {
                this.currentEffectPriority = priority;
                this.currGravityDirection = direction;
                if (rotationParameters != null) {
                    this.currentRotationParameters = rotationParameters;
                }
            }
        } else if (this.delayApplyDirEffect == null || priority > this.delayApplyDirEffect.priority()) {
            this.delayApplyDirEffect = new GravityDirEffect(direction, rotationParameters, priority);
        }
    }

    public void applyGravityStrengthEffect(double strengthMultiplier) {
        if (this.isFiringUpdateEvent) {
            this.currGravityStrength *= strengthMultiplier;
        } else {
            this.delayApplyStrengthEffect *= strengthMultiplier;
        }
    }

    public void applySyncPacket(class_2540 buf) {
        super.applySyncPacket(buf);
        if (this.entity.method_37908().method_8608()) {
            this.applyGravityChange();
        }
    }

    public void applyGravityDirectionChange(class_2350 oldGravity, class_2350 newGravity, RotationParameters rotationParameters, boolean isInitialization) {
        if (!this.canChangeGravity()) {
            return;
        }
        this.entity.method_5857(((EntityAccessor)this.entity).gc_makeBoundingBox());
        if (isInitialization) {
            return;
        }
        this.entity.field_6017 = 0.0f;
        long timeMs = this.entity.method_37908().method_8510() * 50L;
        class_243 relativeRotationCenter = GravityComponent.getLocalRotationCenter(this.entity, oldGravity, newGravity, rotationParameters);
        class_243 oldPos = this.entity.method_19538();
        class_243 oldLastTickPos = new class_243(this.entity.field_6038, this.entity.field_5971, this.entity.field_5989);
        class_243 rotationCenter = oldPos.method_1019(RotationUtil.vecPlayerToWorld(relativeRotationCenter, oldGravity));
        class_243 newPos = rotationCenter.method_1020(RotationUtil.vecPlayerToWorld(relativeRotationCenter, newGravity));
        class_243 posTranslation = newPos.method_1020(oldPos);
        class_243 newLastTickPos = oldLastTickPos.method_1019(posTranslation);
        this.entity.method_33574(newPos);
        this.entity.field_6014 = newLastTickPos.field_1352;
        this.entity.field_6036 = newLastTickPos.field_1351;
        this.entity.field_5969 = newLastTickPos.field_1350;
        this.entity.field_6038 = newLastTickPos.field_1352;
        this.entity.field_5971 = newLastTickPos.field_1351;
        this.entity.field_5989 = newLastTickPos.field_1350;
        this.adjustEntityPosition(oldGravity, newGravity, this.entity.method_5829());
        if (this.entity.method_37908().method_8608()) {
            Validate.notNull((Object)this.animation, (String)"gravity animation is null", (Object[])new Object[0]);
            int rotationTimeMS = rotationParameters.rotationTimeMS();
            this.animation.startRotationAnimation(newGravity, oldGravity, rotationTimeMS, this.entity, timeMs, rotationParameters.rotateView(), relativeRotationCenter);
        }
        class_243 realWorldVelocity = GravityComponent.getRealWorldVelocity(this.entity, oldGravity);
        if (rotationParameters.rotateVelocity()) {
            Vector3f worldSpaceVec = realWorldVelocity.method_46409();
            worldSpaceVec.rotate((Quaternionfc)RotationUtil.getRotationBetween(oldGravity, newGravity));
            this.entity.method_18799(RotationUtil.vecWorldToPlayer(new class_243(worldSpaceVec), newGravity));
        } else {
            this.entity.method_18799(RotationUtil.vecWorldToPlayer(realWorldVelocity, newGravity));
        }
    }

    private static class_243 getRealWorldVelocity(class_1297 entity, class_2350 prevGravityDirection) {
        if (entity.method_5787()) {
            return new class_243(entity.method_23317() - entity.field_6014, entity.method_23318() - entity.field_6036, entity.method_23321() - entity.field_5969);
        }
        return RotationUtil.vecPlayerToWorld(entity.method_18798(), prevGravityDirection);
    }

    @NotNull
    private static class_243 getLocalRotationCenter(class_1297 entity, class_2350 oldGravity, class_2350 newGravity, RotationParameters rotationParameters) {
        if (entity instanceof class_1511) {
            return new class_243(0.0, -0.5, 0.0);
        }
        class_4048 dimensions = entity.method_18377(entity.method_18376());
        if (newGravity.method_10153() == oldGravity) {
            return new class_243(0.0, (double)(dimensions.field_18068 / 2.0f), 0.0);
        }
        return class_243.field_1353;
    }

    private void adjustEntityPosition(class_2350 oldGravity, class_2350 newGravity, class_238 entityBoundingBox) {
        if (!GravityChangerMod.config.adjustPositionAfterChangingGravity) {
            return;
        }
        if (this.entity instanceof class_1295 || this.entity instanceof class_1665 || this.entity instanceof class_1511) {
            return;
        }
        class_2350 movingDirection = oldGravity.method_10153();
        Iterable collisions = this.entity.method_37908().method_8600(this.entity, entityBoundingBox.method_1014(-0.01));
        class_238 totalCollisionBox = null;
        for (class_265 collision : collisions) {
            if (collision.method_1110()) continue;
            class_238 boundingBox = collision.method_1107();
            if (totalCollisionBox == null) {
                totalCollisionBox = boundingBox;
                continue;
            }
            totalCollisionBox = totalCollisionBox.method_991(boundingBox);
        }
        if (totalCollisionBox != null) {
            class_243 positionAdjustmentOffset = GravityComponent.getPositionAdjustmentOffset(entityBoundingBox, totalCollisionBox, movingDirection);
            if (this.entity instanceof class_1657) {
                LOGGER.info("Adjusting player position {} {}", (Object)positionAdjustmentOffset, (Object)this.entity);
            }
            this.entity.method_33574(this.entity.method_19538().method_1019(positionAdjustmentOffset));
        }
    }

    private static class_243 getPositionAdjustmentOffset(class_238 entityBoundingBox, class_238 nearbyCollisionUnion, class_2350 movingDirection) {
        class_2350.class_2351 axis = movingDirection.method_10166();
        double offset = 0.0;
        if (movingDirection.method_10171() == class_2350.class_2352.field_11056) {
            double pushed;
            double pushing = nearbyCollisionUnion.method_990(axis);
            if (pushing > (pushed = entityBoundingBox.method_1001(axis))) {
                offset = pushing - pushed;
            }
        } else {
            double pushed;
            double pushing = nearbyCollisionUnion.method_1001(axis);
            if (pushing < (pushed = entityBoundingBox.method_990(axis))) {
                offset = pushed - pushing;
            }
        }
        return new class_243(movingDirection.method_23955()).method_1021(offset);
    }

    public double getBaseGravityStrength() {
        return this.baseGravityStrength;
    }

    public void setBaseGravityStrength(double strength) {
        if (!this.canChangeGravity()) {
            return;
        }
        this.baseGravityStrength = strength;
        this.needsSync = true;
    }

    public class_2350 getCurrGravityDirection() {
        return this.currGravityDirection;
    }

    public double getCurrGravityStrength() {
        return this.currGravityStrength;
    }

    private boolean canChangeGravity() {
        return EntityTags.canChangeGravity(this.entity);
    }

    public class_2350 getPrevGravityDirection() {
        return this.prevGravityDirection;
    }

    public class_2350 getBaseGravityDirection() {
        return this.baseGravityDirection;
    }

    public void setBaseGravityDirection(class_2350 gravityDirection) {
        if (!this.canChangeGravity()) {
            return;
        }
        if (this.baseGravityDirection != gravityDirection) {
            this.baseGravityDirection = gravityDirection;
            this.needsSync = true;
            this.updateGravityStatus(false);
        }
    }

    public void reset() {
        this.baseGravityDirection = class_2350.field_11033;
        this.baseGravityStrength = 1.0;
        this.needsSync = true;
    }

    @Environment(value=EnvType.CLIENT)
    public RotationAnimation getRotationAnimation() {
        return this.animation;
    }

    public void applyGravityChange() {
        if (this.currentRotationParameters == null) {
            this.currentRotationParameters = RotationParameters.getDefault();
        }
        if (this.prevGravityDirection != this.currGravityDirection) {
            this.applyGravityDirectionChange(this.prevGravityDirection, this.currGravityDirection, this.currentRotationParameters, false);
            this.prevGravityDirection = this.currGravityDirection;
        }
        if (Math.abs(this.currGravityStrength - this.prevGravityStrength) > 1.0E-4) {
            this.prevGravityStrength = this.currGravityStrength;
        }
    }

    public void forceApplyGravityChange() {
        this.prevGravityDirection = this.currGravityDirection;
        this.prevGravityStrength = this.currGravityStrength;
    }

    private record GravityDirEffect(@NotNull class_2350 direction, @Nullable RotationParameters rotationParameters, double priority) {
    }

    public static interface GravityUpdateCallback {
        public void update(class_1297 var1, GravityComponent var2);
    }
}

