/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.api;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import gravity_changer.DimensionGravityDataComponent;
import gravity_changer.EntityTags;
import gravity_changer.GravityChangerComponents;
import gravity_changer.GravityComponent;
import gravity_changer.RotationAnimation;
import gravity_changer.util.RotationUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public abstract class GravityChangerAPI {
    public static final ComponentKey<GravityComponent> GRAVITY_COMPONENT = GravityChangerComponents.GRAVITY_COMP_KEY;
    public static final ComponentKey<DimensionGravityDataComponent> DIMENSION_DATA_COMPONENT = GravityChangerComponents.DIMENSION_COMP_KEY;

    public static class_2350 getGravityDirection(class_1297 entity) {
        GravityComponent comp = GravityChangerAPI.getGravityComponentEarly(entity);
        if (comp == null) {
            return class_2350.field_11033;
        }
        return comp.getCurrGravityDirection();
    }

    public static double getGravityStrength(class_1297 entity) {
        return GravityChangerAPI.getGravityComponent(entity).getCurrGravityStrength();
    }

    public static double getBaseGravityStrength(class_1297 entity) {
        return GravityChangerAPI.getGravityComponent(entity).getBaseGravityStrength();
    }

    public static void setBaseGravityStrength(class_1297 entity, double strength) {
        GravityComponent component = GravityChangerAPI.getGravityComponent(entity);
        component.setBaseGravityStrength(strength);
    }

    public static double getDimensionGravityStrength(class_1937 world) {
        return ((DimensionGravityDataComponent)DIMENSION_DATA_COMPONENT.get((Object)world)).getDimensionGravityStrength();
    }

    public static void setDimensionGravityStrength(class_1937 world, double strength) {
        ((DimensionGravityDataComponent)DIMENSION_DATA_COMPONENT.get((Object)world)).setDimensionGravityStrength(strength);
    }

    public static void resetGravity(class_1297 entity) {
        if (!EntityTags.canChangeGravity(entity)) {
            return;
        }
        GravityChangerAPI.getGravityComponent(entity).reset();
    }

    public static class_2350 getBaseGravityDirection(class_1297 entity) {
        return GravityChangerAPI.getGravityComponent(entity).getBaseGravityDirection();
    }

    public static void setBaseGravityDirection(class_1297 entity, class_2350 gravityDirection) {
        GravityComponent component = GravityChangerAPI.getGravityComponent(entity);
        component.setBaseGravityDirection(gravityDirection);
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static RotationAnimation getRotationAnimation(class_1297 entity) {
        return GravityChangerAPI.getGravityComponent(entity).getRotationAnimation();
    }

    public static void instantlySetClientBaseGravityDirection(class_1297 entity, class_2350 direction) {
        Validate.isTrue((boolean)entity.method_37908().method_8608(), (String)"should only be used on client", (Object[])new Object[0]);
        GravityComponent component = GravityChangerAPI.getGravityComponent(entity);
        component.setBaseGravityDirection(direction);
        component.updateGravityStatus(false);
        component.forceApplyGravityChange();
    }

    public static GravityComponent getGravityComponent(class_1297 entity) {
        return (GravityComponent)GRAVITY_COMPONENT.get((Object)entity);
    }

    @Nullable
    public static GravityComponent getGravityComponentEarly(class_1297 entity) {
        if (((ComponentProvider)entity).getComponentContainer() == null) {
            return null;
        }
        return GravityChangerAPI.getGravityComponent(entity);
    }

    public static class_243 getWorldVelocity(class_1297 entity) {
        return RotationUtil.vecPlayerToWorld(entity.method_18798(), GravityChangerAPI.getGravityDirection(entity));
    }

    public static void setWorldVelocity(class_1297 entity, class_243 worldVelocity) {
        entity.method_18799(RotationUtil.vecWorldToPlayer(worldVelocity, GravityChangerAPI.getGravityDirection(entity)));
    }

    public static class_243 getEyeOffset(class_1297 entity) {
        return RotationUtil.vecPlayerToWorld(0.0, (double)entity.method_5751(), 0.0, GravityChangerAPI.getGravityDirection(entity));
    }

    public static boolean canChangeGravity(class_1297 entity) {
        return EntityTags.canChangeGravity(entity);
    }
}

