/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import gravity_changer.GravityComponent;
import gravity_changer.api.GravityChangerAPI;
import gravity_changer.command.DirectionArgumentType;
import gravity_changer.command.LocalDirection;
import gravity_changer.command.LocalDirectionArgumentType;
import gravity_changer.util.GCUtil;
import gravity_changer.util.RotationUtil;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.apache.commons.lang3.Validate;

public class GravityCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"gravity").requires(source -> source.method_9259(2));
        builder.then(class_2170.method_9247((String)"set_base_direction").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"direction", (ArgumentType)DirectionArgumentType.instance).executes(context -> {
            class_1297 entity = ((class_2168)context.getSource()).method_9228();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            class_2350 direction = DirectionArgumentType.getDirection(context, "direction");
            GravityChangerAPI.setBaseGravityDirection(entity, direction);
            return 1;
        })).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"entities");
            class_2350 direction = DirectionArgumentType.getDirection(context, "direction");
            for (class_1297 entity : entities) {
                GravityChangerAPI.setBaseGravityDirection(entity, direction);
            }
            return entities.size();
        }))));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(context -> {
            class_1297 entity = ((class_2168)context.getSource()).method_9228();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            GravityChangerAPI.resetGravity(entity);
            return 1;
        })).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"entities");
            for (class_1297 entity : entities) {
                GravityChangerAPI.resetGravity(entity);
            }
            return entities.size();
        })));
        builder.then(class_2170.method_9247((String)"set_base_strength").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"strength", (ArgumentType)DoubleArgumentType.doubleArg((double)-20.0, (double)20.0)).executes(context -> {
            class_1297 entity = ((class_2168)context.getSource()).method_9228();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            double strength = DoubleArgumentType.getDouble((CommandContext)context, (String)"strength");
            return GravityCommand.executeSetBaseStrength(List.of(entity), strength);
        })).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"entities");
            double strength = DoubleArgumentType.getDouble((CommandContext)context, (String)"strength");
            return GravityCommand.executeSetBaseStrength(entities, strength);
        }))));
        builder.then(class_2170.method_9247((String)"view").executes(context -> {
            class_1297 entity = ((class_2168)context.getSource()).method_9228();
            GravityComponent component = GravityChangerAPI.getGravityComponent(entity);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"gravity_changer.command.inform", (Object[])new Object[]{component.getBaseGravityDirection().method_10151(), component.getBaseGravityStrength()}), false);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"randomize_base_direction").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_1297 entity = source.method_9228();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            return GravityCommand.executeRandomizeBaseDirection(source, List.of(entity));
        })).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"entities");
            return GravityCommand.executeRandomizeBaseDirection(source, entities);
        })));
        builder.then(class_2170.method_9247((String)"set_relative_base_direction").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"relativeDirection", (ArgumentType)LocalDirectionArgumentType.instance).executes(context -> {
            LocalDirection relativeDirection = LocalDirectionArgumentType.getDirection(context, "relativeDirection");
            class_1297 entity = ((class_2168)context.getSource()).method_9228();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            return GravityCommand.executeSetRelativeBaseDir((class_2168)context.getSource(), relativeDirection, List.of(entity));
        })).then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(context -> {
            LocalDirection relativeDirection = LocalDirectionArgumentType.getDirection(context, "relativeDirection");
            Collection entities = class_2186.method_9317((CommandContext)context, (String)"entities");
            return GravityCommand.executeSetRelativeBaseDir((class_2168)context.getSource(), relativeDirection, entities);
        }))));
        builder.then(class_2170.method_9247((String)"set_dimension_gravity_strength").then(class_2170.method_9244((String)"strength", (ArgumentType)DoubleArgumentType.doubleArg((double)-20.0, (double)20.0)).executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            double strength = DoubleArgumentType.getDouble((CommandContext)context, (String)"strength");
            GravityChangerAPI.setDimensionGravityStrength((class_1937)world, strength);
            return 0;
        })));
        builder.then(class_2170.method_9247((String)"view_dimension_info").executes(context -> {
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            double strength = GravityChangerAPI.getDimensionGravityStrength((class_1937)world);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"gravity_changer.command.dimension_info", (Object[])new Object[]{strength}), false);
            return 0;
        }));
        dispatcher.register(builder);
    }

    private static int executeSetBaseStrength(Collection<? extends class_1297> entities, double strength) {
        for (class_1297 class_12972 : entities) {
            GravityChangerAPI.setBaseGravityStrength(class_12972, strength);
        }
        return entities.size();
    }

    private static int executeRandomizeBaseDirection(class_2168 source, Collection<? extends class_1297> entities) {
        class_5819 random = source.method_9225().field_9229;
        for (class_1297 class_12972 : entities) {
            class_2350 gravityDirection = class_2350.method_10162((class_5819)random);
            GravityChangerAPI.setBaseGravityDirection(class_12972, gravityDirection);
        }
        return entities.size();
    }

    private static void getSendFeedback(class_2168 source, class_1297 entity, class_2350 gravityDirection) {
        class_5250 text = GCUtil.getDirectionText(gravityDirection);
        if (source.method_9228() != null && source.method_9228() == entity) {
            source.method_9226(() -> GravityCommand.lambda$getSendFeedback$16((class_2561)text), true);
        } else {
            source.method_9226(() -> GravityCommand.lambda$getSendFeedback$17(entity, (class_2561)text), true);
        }
    }

    private static int executeSetRelativeBaseDir(class_2168 source, LocalDirection relativeDirection, Collection<? extends class_1297> entities) {
        int i = 0;
        for (class_1297 class_12972 : entities) {
            class_2350 gravityDirection = GravityChangerAPI.getGravityDirection(class_12972);
            class_2350 combinedRelativeDirection = switch (relativeDirection) {
                default -> throw new IncompatibleClassChangeError();
                case LocalDirection.DOWN -> class_2350.field_11033;
                case LocalDirection.UP -> class_2350.field_11036;
                case LocalDirection.FORWARD, LocalDirection.BACKWARD, LocalDirection.LEFT, LocalDirection.RIGHT -> class_2350.method_10139((int)(relativeDirection.getHorizontalOffset() + class_2350.method_10150((double)class_12972.method_36454()).method_10161()));
            };
            class_2350 newGravityDirection = RotationUtil.dirPlayerToWorld(combinedRelativeDirection, gravityDirection);
            GravityChangerAPI.setBaseGravityDirection(class_12972, newGravityDirection);
            GravityCommand.getSendFeedback(source, class_12972, newGravityDirection);
            ++i;
        }
        return i;
    }

    private static /* synthetic */ class_2561 lambda$getSendFeedback$17(class_1297 entity, class_2561 text) {
        return class_2561.method_43469((String)"commands.gravity.get.other", (Object[])new Object[]{entity.method_5476(), text});
    }

    private static /* synthetic */ class_2561 lambda$getSendFeedback$16(class_2561 text) {
        return class_2561.method_43469((String)"commands.gravity.get.self", (Object[])new Object[]{text});
    }
}

