/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.plating;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import gravity_changer.plating.GravityPlatingBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravityPlatingBlock
extends class_2237 {
    public static final MapCodec<GravityPlatingBlock> CODEC = GravityPlatingBlock.method_54094(GravityPlatingBlock::new);
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    protected static final class_265 DOWN_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final class_265 WEST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesByState;
    public static final class_2248 PLATING_BLOCK = new GravityPlatingBlock(FabricBlockSettings.of().method_22488().method_9634().method_9618());

    public static void init() {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("gravity_changer:plating"), (Object)PLATING_BLOCK);
    }

    public GravityPlatingBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), GravityPlatingBlock::getShapeForState)));
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SOUTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NORTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)WEST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)EAST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)DOWN)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)DOWN_SHAPE);
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByState.get(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (GravityPlatingBlock.hasDir(state, direction) && !this.canPlaceOn((class_1922)world, pos.method_10093(direction), direction.method_10153())) {
            if (GravityPlatingBlock.getDirections(state = (class_2680)state.method_11657((class_2769)GravityPlatingBlock.directionToProperty(direction), (Comparable)Boolean.valueOf(false))).size() == 0) {
                return class_2246.field_10124.method_9564();
            }
            return state;
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GravityPlatingBlockEntity(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (world.field_9236) {
            return GravityPlatingBlock.method_31618(type, GravityPlatingBlockEntity.TYPE, GravityPlatingBlockEntity::tick);
        }
        return GravityPlatingBlock.method_31618(type, GravityPlatingBlockEntity.TYPE, GravityPlatingBlockEntity::tick);
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        if (!context.method_8046() && context.method_8041().method_7909() == this.method_8389()) {
            return !GravityPlatingBlock.hasDir(state, context.method_8038().method_10153());
        }
        return super.method_9616(state, context);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        if (blockState.method_27852((class_2248)this)) {
            return (class_2680)blockState.method_11657((class_2769)GravityPlatingBlock.directionToProperty(ctx.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
        }
        return (class_2680)this.method_9564().method_11657((class_2769)GravityPlatingBlock.directionToProperty(ctx.method_8038().method_10153()), (Comparable)Boolean.valueOf(true));
    }

    private boolean canPlaceOn(class_1922 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26206(world, pos, side);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        ArrayList<class_2350> directions = GravityPlatingBlock.getDirections(state);
        if (directions.size() == 1) {
            return this.canPlaceOn((class_1922)world, pos.method_10093(directions.get(0)), directions.get(0).method_10153());
        }
        if (directions.size() > 1) {
            for (class_2350 dir : GravityPlatingBlock.getDirections(world.method_8320(pos))) {
                directions.remove(dir);
            }
            return this.canPlaceOn((class_1922)world, pos.method_10093(directions.get(0)), directions.get(0).method_10153());
        }
        return false;
    }

    public static class_2746 directionToProperty(class_2350 direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11036 -> UP;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }

    public static boolean hasDir(class_2680 blockState, class_2350 dir) {
        return (Boolean)blockState.method_11654((class_2769)GravityPlatingBlock.directionToProperty(dir));
    }

    public static ArrayList<class_2350> getDirections(class_2680 blockState) {
        ArrayList<class_2350> list = new ArrayList<class_2350>();
        for (int directionId = 0; directionId < 6; ++directionId) {
            class_2350 direction = class_2350.method_10143((int)directionId);
            if (!GravityPlatingBlock.hasDir(blockState, direction)) continue;
            list.add(direction);
        }
        return list;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2350 hitDir = hit.method_17780();
        class_2350 plateDir = hitDir.method_10153();
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof GravityPlatingBlockEntity)) {
            return class_1269.field_5814;
        }
        GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
        return be.interact(level, pos, plateDir, player, hand);
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof GravityPlatingBlockEntity) {
            GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
            if (!level.field_9236 && player.method_7337()) {
                List<class_1799> drops = be.getDrops();
                for (class_1799 itemStack : drops) {
                    class_1542 itemEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                    itemEntity.method_6988();
                    level.method_8649((class_1297)itemEntity);
                }
            }
        }
        return super.method_9576(level, pos, state, player);
    }

    public List<class_1799> method_9560(class_2680 blockState, class_8567.class_8568 builder) {
        class_2586 blockEntity = (class_2586)builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof GravityPlatingBlockEntity) {
            GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
            return be.getDrops();
        }
        return List.of();
    }
}

