/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.plating;

import com.mojang.logging.LogUtils;
import gravity_changer.EntityTags;
import gravity_changer.GravityChangerMod;
import gravity_changer.GravityComponent;
import gravity_changer.api.GravityChangerAPI;
import gravity_changer.plating.GravityPlatingBlock;
import gravity_changer.plating.GravityPlatingItem;
import gravity_changer.util.GCUtil;
import gravity_changer.util.RotationUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class GravityPlatingBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 ID = new class_2960("gravity_changer:plating_block_entity");
    public static class_2591<GravityPlatingBlockEntity> TYPE;
    private static final int MAX_LEVEL = 64;
    @Nullable
    private SideData[] sideData = null;
    @Nullable
    private class_238 roughAreaBoxCache = null;

    public static void init() {
        TYPE = FabricBlockEntityTypeBuilder.create(GravityPlatingBlockEntity::new, (class_2248[])new class_2248[]{GravityPlatingBlock.PLATING_BLOCK}).build();
        class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)ID, TYPE);
    }

    public GravityPlatingBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.sideData = new SideData[6];
        for (class_2350 dir : class_2350.values()) {
            String dirName = dir.method_10151();
            if (!tag.method_10545(dirName)) continue;
            class_2487 sideTag = tag.method_10562(dirName);
            this.sideData[dir.ordinal()] = SideData.fromTag(sideTag);
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.sideData != null) {
            for (class_2350 dir : class_2350.values()) {
                String dirName = dir.method_10151();
                SideData side = this.sideData[dir.ordinal()];
                if (side == null) continue;
                tag.method_10566(dirName, (class_2520)side.toTag());
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    public void refreshCache() {
        class_1937 world = this.method_10997();
        if (world == null) {
            LOGGER.error("Refreshing cache when world is null {}", (Object)this);
            return;
        }
        if (this.sideData == null) {
            this.sideData = new SideData[6];
        }
        class_2680 blockState = world.method_8320(this.method_11016());
        for (class_2350 class_23502 : class_2350.values()) {
            if (GravityPlatingBlock.hasDir(blockState, class_23502)) {
                if (this.sideData[class_23502.ordinal()] != null) continue;
                this.sideData[class_23502.ordinal()] = SideData.createDefault();
                continue;
            }
            this.sideData[class_23502.ordinal()] = null;
        }
        if ((long)(this.field_11867.hashCode() % 5) == world.method_8510() % 5L) {
            this.roughAreaBoxCache = null;
            for (SideData sideData : this.sideData) {
                if (sideData == null) continue;
                sideData.effectBoxCache = null;
            }
        }
    }

    private class_238 getRoughEffectBox() {
        if (this.roughAreaBoxCache == null) {
            double maxRange = 0.0;
            for (SideData sideDatum : this.sideData) {
                if (sideDatum == null) continue;
                maxRange = Math.max(maxRange, sideDatum.getEffectRange());
            }
            class_2338 blockPos = this.method_11016();
            double expand = 0.001;
            double delta = maxRange + expand;
            return new class_238((double)blockPos.method_10263() - delta, (double)blockPos.method_10264() - delta, (double)blockPos.method_10260() - delta, (double)(blockPos.method_10263() + 1) + delta, (double)(blockPos.method_10264() + 1) + delta, (double)(blockPos.method_10260() + 1) + delta);
        }
        return this.roughAreaBoxCache;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, GravityPlatingBlockEntity be) {
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof GravityPlatingBlock)) {
            return;
        }
        GravityPlatingBlock gravityPlatingBlock = (GravityPlatingBlock)class_22482;
        be.refreshCache();
        class_238 roughBox = be.getRoughEffectBox();
        List entities = world.method_8390(class_1297.class, roughBox, e -> EntityTags.canChangeGravity(e));
        for (class_1297 entity : entities) {
            boolean applies = false;
            GravityComponent comp = GravityChangerAPI.getGravityComponent(entity);
            class_2350 entityGravityDir = comp.getCurrGravityDirection();
            for (class_2350 plateDir : class_2350.values()) {
                double adjustment;
                SideData sideDatum = be.sideData[plateDir.ordinal()];
                if (sideDatum == null) continue;
                class_2350 gravityEffectDir = sideDatum.isAttracting ? plateDir : plateDir.method_10153();
                boolean isOpposite = entityGravityDir == gravityEffectDir.method_10153();
                class_243 testingPos = isOpposite ? entity.method_33571() : entity.method_19538();
                class_238 gravityEffectBox = sideDatum.getEffectBox(blockPos, plateDir, world);
                if (!gravityEffectBox.method_1006(testingPos)) continue;
                class_243 plateDirVec = class_243.method_24954((class_2382)plateDir.method_10163());
                class_243 effectCenter = class_243.method_24953((class_2382)blockPos).method_1019(plateDirVec.method_1021(0.5));
                class_243 effectCenterAdjusted = effectCenter.method_1019(plateDirVec.method_1021(-(adjustment = 0.1)));
                class_243 deltaVec = testingPos.method_1020(effectCenterAdjusted);
                double distanceToPlane = -deltaVec.method_1026(plateDirVec);
                if (distanceToPlane < -adjustment - 0.001) continue;
                class_243 localVec = RotationUtil.vecWorldToPlayer(deltaVec, plateDir);
                double dx = GCUtil.distanceToRange(localVec.field_1352, -0.5, 0.5);
                double dz = GCUtil.distanceToRange(localVec.field_1350, -0.5, 0.5);
                double distanceToPlate = Math.sqrt(dx * dx + dz * dz + distanceToPlane * distanceToPlane);
                double priority = 1000.0 - distanceToPlate;
                if (isOpposite) {
                    priority -= 10.0;
                }
                comp.applyGravityDirectionEffect(gravityEffectDir, null, priority);
                applies = true;
            }
            if (!applies || !GravityChangerMod.config.autoJumpOnGravityPlateInnerCorner) continue;
            GravityPlatingBlockEntity.tryToDoCornerAutoJump(blockState, blockPos, entity, comp);
        }
    }

    private static void tryToDoCornerAutoJump(class_2680 blockState, class_2338 blockPos, class_1297 entity, GravityComponent comp) {
        if (!entity.method_24828()) {
            return;
        }
        class_2350 entityGravityDir = comp.getCurrGravityDirection();
        for (class_2350 plateDir : class_2350.values()) {
            double distanceToPlate;
            class_243 worldVelocity;
            boolean orthogonal;
            if (!GravityPlatingBlock.hasDir(blockState, plateDir)) continue;
            boolean bl = orthogonal = entityGravityDir.method_10166() != plateDir.method_10166();
            if (!orthogonal) continue;
            class_243 plateDirVec = class_243.method_24954((class_2382)plateDir.method_10163());
            class_243 effectCenter = class_243.method_24953((class_2382)blockPos).method_1019(plateDirVec.method_1021(0.5));
            class_243 offset = effectCenter.method_1020(entity.method_19538());
            if (offset.method_1026(class_243.method_24954((class_2382)entityGravityDir.method_10163())) > 0.0 || (worldVelocity = GravityChangerAPI.getWorldVelocity(entity)).method_1026(plateDirVec) < 0.01 || !((distanceToPlate = Math.abs(entity.method_19538().method_1020(effectCenter).method_1026(plateDirVec))) < 0.8)) continue;
            double strengthSqrt = Math.sqrt(comp.getCurrGravityStrength());
            class_243 entityGravityVec = class_243.method_24954((class_2382)entityGravityDir.method_10163());
            class_243 deltaWorldVelocity = entityGravityVec.method_1021(-strengthSqrt * 0.4).method_1019(plateDirVec.method_1021(0.08));
            GravityChangerAPI.setWorldVelocity(entity, GravityChangerAPI.getWorldVelocity(entity).method_1019(deltaWorldVelocity));
            if (entity.method_37908().method_8608()) {
                LOGGER.info("Client entity auto-jump on gravity plate corner {}", (Object)entity);
            }
            return;
        }
    }

    public class_1269 interact(class_1937 level, class_2338 pos, class_2350 plateDir, class_1657 player, class_1268 hand) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        this.refreshCache();
        SideData sideDatum = this.sideData[plateDir.ordinal()];
        if (sideDatum == null) {
            return class_1269.field_5814;
        }
        class_1799 handItem = player.method_5998(hand);
        if (handItem.method_7909() == class_1802.field_8162) {
            if (sideDatum.level != 1) {
                --sideDatum.level;
                if (!player.method_7337()) {
                    player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_27069));
                }
            } else {
                sideDatum.isAttracting = !sideDatum.isAttracting;
            }
        } else if (handItem.method_7909() == class_1802.field_27069) {
            if (!player.method_7337()) {
                handItem.method_7934(1);
            }
            ++sideDatum.level;
            if (sideDatum.level > 64) {
                sideDatum.level = 64;
            }
        } else {
            ((class_3222)player).method_43502((class_2561)class_2561.method_43471((String)"gravity_changer.plate.wrong_interaction"), true);
            return class_1269.field_5814;
        }
        this.sync();
        boolean isAttracting = sideDatum.isAttracting;
        ((class_3222)player).method_43502((class_2561)class_2561.method_43469((String)"gravity_changer.plate.status", (Object[])new Object[]{GCUtil.getDirectionText(plateDir.method_10153()), sideDatum.level, GravityPlatingBlockEntity.getForceText(isAttracting)}), true);
        return class_1269.field_5812;
    }

    public static class_5250 getForceText(boolean isAttracting) {
        return class_2561.method_43471((String)(isAttracting ? "gravity_changer.plate.force.attract" : "gravity_changer.plate.force.repulse"));
    }

    public void sync() {
        class_1937 world = this.method_10997();
        Validate.notNull((Object)world);
        Validate.isTrue((!world.method_8608() ? 1 : 0) != 0);
        this.method_5431();
        ((class_3215)world.method_8398()).method_14128(this.method_11016());
    }

    public void onPlacing(class_2350 side, SideData sideData) {
        this.refreshCache();
        this.sideData[side.ordinal()] = sideData;
        this.sync();
    }

    public List<class_1799> getDrops() {
        if (this.sideData == null) {
            return List.of();
        }
        ArrayList<class_1799> drops = new ArrayList<class_1799>();
        for (class_2350 value : class_2350.values()) {
            SideData sideDatum = this.sideData[value.ordinal()];
            if (sideDatum == null) continue;
            class_1799 stack = GravityPlatingItem.createStack(sideDatum);
            drops.add(stack);
        }
        return drops;
    }

    public static class SideData {
        public boolean isAttracting = true;
        public int level = 1;
        @Nullable
        public class_238 effectBoxCache = null;

        public SideData(boolean isAttracting, int level) {
            this.isAttracting = isAttracting;
            this.level = level;
        }

        public static SideData createDefault() {
            return new SideData(true, 1);
        }

        public static SideData fromTag(class_2487 tag) {
            boolean isAttracting_ = tag.method_10577("isAttracting");
            int level_ = tag.method_10550("level");
            level_ = class_3532.method_15340((int)level_, (int)1, (int)64);
            return new SideData(isAttracting_, level_);
        }

        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10556("isAttracting", this.isAttracting);
            tag.method_10569("level", this.level);
            return tag;
        }

        public double getEffectRange() {
            return (double)this.level - 0.1;
        }

        public class_238 getEffectBox(class_2338 blockPos, class_2350 plateDir, class_1937 world) {
            if (this.effectBoxCache == null) {
                double expand = 0.001;
                double minX = (double)blockPos.method_10263() - expand;
                double minY = (double)blockPos.method_10264() - expand;
                double minZ = (double)blockPos.method_10260() - expand;
                double maxX = (double)(blockPos.method_10263() + 1) + expand;
                double maxY = (double)(blockPos.method_10264() + 1) + expand;
                double maxZ = (double)(blockPos.method_10260() + 1) + expand;
                double delta = this.getEffectRange() - 1.0;
                switch (plateDir) {
                    case field_11033: {
                        maxY += delta;
                        break;
                    }
                    case field_11036: {
                        minY -= delta;
                        break;
                    }
                    case field_11043: {
                        maxZ += delta;
                        break;
                    }
                    case field_11035: {
                        minZ -= delta;
                        break;
                    }
                    case field_11039: {
                        maxX += delta;
                        break;
                    }
                    case field_11034: {
                        minX -= delta;
                    }
                }
                class_2338 wallPos = blockPos.method_10093(plateDir);
                block16: for (class_2350 sideDir : class_2350.values()) {
                    class_2586 class_25862;
                    class_2338 sidePos;
                    class_2680 sideBlockState;
                    class_2248 class_22482;
                    if (sideDir.method_10166() == plateDir.method_10166() || !((class_22482 = (sideBlockState = world.method_8320(sidePos = wallPos.method_10093(sideDir))).method_26204()) instanceof GravityPlatingBlock)) continue;
                    GravityPlatingBlock sidePlatingBlock = (GravityPlatingBlock)class_22482;
                    if (!GravityPlatingBlock.hasDir(sideBlockState, sideDir.method_10153()) || !((class_25862 = world.method_8321(sidePos)) instanceof GravityPlatingBlockEntity)) continue;
                    GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)class_25862;
                    if (this.isAttracting != this.isAttracting) continue;
                    double sideDelta = this.getEffectRange();
                    switch (sideDir) {
                        case field_11033: {
                            minY -= sideDelta;
                            continue block16;
                        }
                        case field_11036: {
                            maxY += sideDelta;
                            continue block16;
                        }
                        case field_11043: {
                            minZ -= sideDelta;
                            continue block16;
                        }
                        case field_11035: {
                            maxZ += sideDelta;
                            continue block16;
                        }
                        case field_11039: {
                            minX -= sideDelta;
                            continue block16;
                        }
                        case field_11034: {
                            maxX += sideDelta;
                        }
                    }
                }
                this.effectBoxCache = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
            }
            return this.effectBoxCache;
        }
    }
}

