/*
 * Decompiled with CFR 0.152.
 */
package gravity_changer.util;

import gravity_changer.util.QuaternionUtil;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class RotationUtil {
    private static final class_2350[][] DIR_WORLD_TO_PLAYER;
    private static final class_2350[][] DIR_PLAYER_TO_WORLD;
    private static final Quaternionf[] WORLD_ROTATION_QUATERNIONS;
    private static final Quaternionf[] ENTITY_ROTATION_QUATERNIONS;

    public static class_2350 dirWorldToPlayer(class_2350 direction, class_2350 gravityDirection) {
        return DIR_WORLD_TO_PLAYER[gravityDirection.method_10146()][direction.method_10146()];
    }

    public static class_2350 dirPlayerToWorld(class_2350 direction, class_2350 gravityDirection) {
        return DIR_PLAYER_TO_WORLD[gravityDirection.method_10146()][direction.method_10146()];
    }

    public static class_243 vecWorldToPlayer(double x, double y, double z, class_2350 gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new class_243(x, y, z);
            case class_2350.field_11036 -> new class_243(-x, -y, z);
            case class_2350.field_11043 -> new class_243(x, z, -y);
            case class_2350.field_11035 -> new class_243(-x, -z, -y);
            case class_2350.field_11039 -> new class_243(-z, x, -y);
            case class_2350.field_11034 -> new class_243(z, -x, -y);
        };
    }

    public static class_243 vecWorldToPlayer(class_243 vec3d, class_2350 gravityDirection) {
        return RotationUtil.vecWorldToPlayer(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, gravityDirection);
    }

    public static class_243 vecPlayerToWorld(double x, double y, double z, class_2350 gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new class_243(x, y, z);
            case class_2350.field_11036 -> new class_243(-x, -y, z);
            case class_2350.field_11043 -> new class_243(x, -z, y);
            case class_2350.field_11035 -> new class_243(-x, -z, -y);
            case class_2350.field_11039 -> new class_243(y, -z, -x);
            case class_2350.field_11034 -> new class_243(-y, -z, x);
        };
    }

    public static class_243 vecPlayerToWorld(class_243 vec3d, class_2350 gravityDirection) {
        return RotationUtil.vecPlayerToWorld(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, gravityDirection);
    }

    public static Vector3f vecWorldToPlayer(float x, float y, float z, class_2350 gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new Vector3f(x, y, z);
            case class_2350.field_11036 -> new Vector3f(-x, -y, z);
            case class_2350.field_11043 -> new Vector3f(x, z, -y);
            case class_2350.field_11035 -> new Vector3f(-x, -z, -y);
            case class_2350.field_11039 -> new Vector3f(-z, x, -y);
            case class_2350.field_11034 -> new Vector3f(z, -x, -y);
        };
    }

    public static Vector3f vecWorldToPlayer(Vector3f vector3F, class_2350 gravityDirection) {
        return RotationUtil.vecWorldToPlayer(vector3F.x(), vector3F.y(), vector3F.z(), gravityDirection);
    }

    public static Vector3f vecPlayerToWorld(float x, float y, float z, class_2350 gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new Vector3f(x, y, z);
            case class_2350.field_11036 -> new Vector3f(-x, -y, z);
            case class_2350.field_11043 -> new Vector3f(x, -z, y);
            case class_2350.field_11035 -> new Vector3f(-x, -z, -y);
            case class_2350.field_11039 -> new Vector3f(y, -z, -x);
            case class_2350.field_11034 -> new Vector3f(-y, -z, x);
        };
    }

    public static Vector3f vecPlayerToWorld(Vector3f vector3F, class_2350 gravityDirection) {
        return RotationUtil.vecPlayerToWorld(vector3F.x(), vector3F.y(), vector3F.z(), gravityDirection);
    }

    public static class_243 maskWorldToPlayer(double x, double y, double z, class_2350 gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> new class_243(x, y, z);
            case class_2350.field_11043, class_2350.field_11035 -> new class_243(x, z, y);
            case class_2350.field_11039, class_2350.field_11034 -> new class_243(z, x, y);
        };
    }

    public static class_243 maskWorldToPlayer(class_243 vec3d, class_2350 gravityDirection) {
        return RotationUtil.maskWorldToPlayer(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, gravityDirection);
    }

    public static class_243 maskPlayerToWorld(double x, double y, double z, class_2350 gravityDirection) {
        return switch (gravityDirection) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> new class_243(x, y, z);
            case class_2350.field_11043, class_2350.field_11035 -> new class_243(x, z, y);
            case class_2350.field_11039, class_2350.field_11034 -> new class_243(y, z, x);
        };
    }

    public static class_243 maskPlayerToWorld(class_243 vec3d, class_2350 gravityDirection) {
        return RotationUtil.maskPlayerToWorld(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, gravityDirection);
    }

    public static class_238 boxWorldToPlayer(class_238 box, class_2350 gravityDirection) {
        return new class_238(RotationUtil.vecWorldToPlayer(box.field_1323, box.field_1322, box.field_1321, gravityDirection), RotationUtil.vecWorldToPlayer(box.field_1320, box.field_1325, box.field_1324, gravityDirection));
    }

    public static class_238 boxPlayerToWorld(class_238 box, class_2350 gravityDirection) {
        return new class_238(RotationUtil.vecPlayerToWorld(box.field_1323, box.field_1322, box.field_1321, gravityDirection), RotationUtil.vecPlayerToWorld(box.field_1320, box.field_1325, box.field_1324, gravityDirection));
    }

    public static class_241 rotWorldToPlayer(float yaw, float pitch, class_2350 gravityDirection) {
        class_243 vec3d = RotationUtil.vecWorldToPlayer(RotationUtil.rotToVec(yaw, pitch), gravityDirection);
        return RotationUtil.vecToRot(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public static class_241 rotWorldToPlayer(class_241 vec2f, class_2350 gravityDirection) {
        return RotationUtil.rotWorldToPlayer(vec2f.field_1343, vec2f.field_1342, gravityDirection);
    }

    public static class_241 rotPlayerToWorld(float yaw, float pitch, class_2350 gravityDirection) {
        class_243 vec3d = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(yaw, pitch), gravityDirection);
        return RotationUtil.vecToRot(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public static class_241 rotPlayerToWorld(class_241 vec2f, class_2350 gravityDirection) {
        return RotationUtil.rotPlayerToWorld(vec2f.field_1343, vec2f.field_1342, gravityDirection);
    }

    public static class_243 rotToVec(float yaw, float pitch) {
        double radPitch = (double)pitch * 0.017453292;
        double radNegYaw = (double)(-yaw) * 0.017453292;
        double cosNegYaw = Math.cos(radNegYaw);
        double sinNegYaw = Math.sin(radNegYaw);
        double cosPitch = Math.cos(radPitch);
        double sinPitch = Math.sin(radPitch);
        return new class_243(sinNegYaw * cosPitch, -sinPitch, cosNegYaw * cosPitch);
    }

    public static class_241 vecToRot(double x, double y, double z) {
        double sinPitch = -y;
        double radPitch = Math.asin(sinPitch);
        double cosPitch = Math.cos(radPitch);
        double sinNegYaw = x / cosPitch;
        double cosNegYaw = class_3532.method_15350((double)(z / cosPitch), (double)-1.0, (double)1.0);
        double radNegYaw = Math.acos(cosNegYaw);
        if (sinNegYaw < 0.0) {
            radNegYaw = Math.PI * 2 - radNegYaw;
        }
        return new class_241(class_3532.method_15393((float)((float)(-radNegYaw) / ((float)Math.PI / 180))), (float)radPitch / ((float)Math.PI / 180));
    }

    public static class_241 vecToRot(class_243 vec3d) {
        return RotationUtil.vecToRot(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    public static Quaternionf getWorldRotationQuaternion(class_2350 gravityDirection) {
        return WORLD_ROTATION_QUATERNIONS[gravityDirection.method_10146()];
    }

    public static Quaternionf getCameraRotationQuaternion(class_2350 gravityDirection) {
        return ENTITY_ROTATION_QUATERNIONS[gravityDirection.method_10146()];
    }

    public static Quaternionf getRotationBetween(class_2350 d1, class_2350 d2) {
        class_243 start = new class_243(d1.method_23955());
        class_243 end = new class_243(d2.method_23955());
        if (d1.method_10153() == d2) {
            return new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), 180.0f);
        }
        return QuaternionUtil.getRotationBetween(start, end);
    }

    public static Quaternionf interpolate(Quaternionf startGravityRotation, Quaternionf endGravityRotation, float progress) {
        return new Quaternionf().set((Quaternionfc)startGravityRotation).slerp((Quaternionfc)endGravityRotation, progress);
    }

    public static class_238 makeBoxFromDimensions(class_4048 dimensions, class_2350 gravityDir, class_243 pos) {
        class_238 rawBox = dimensions.method_30231(0.0, 0.0, 0.0);
        return RotationUtil.boxPlayerToWorld(rawBox, gravityDir).method_997(pos);
    }

    static {
        class_243 directionVector;
        DIR_WORLD_TO_PLAYER = new class_2350[6][];
        for (class_2350 gravityDirection : class_2350.values()) {
            RotationUtil.DIR_WORLD_TO_PLAYER[gravityDirection.method_10146()] = new class_2350[6];
            for (class_2350 direction : class_2350.values()) {
                directionVector = class_243.method_24954((class_2382)direction.method_10163());
                directionVector = RotationUtil.vecWorldToPlayer(directionVector, gravityDirection);
                RotationUtil.DIR_WORLD_TO_PLAYER[gravityDirection.method_10146()][direction.method_10146()] = class_2350.method_10142((double)directionVector.field_1352, (double)directionVector.field_1351, (double)directionVector.field_1350);
            }
        }
        DIR_PLAYER_TO_WORLD = new class_2350[6][];
        for (class_2350 gravityDirection : class_2350.values()) {
            RotationUtil.DIR_PLAYER_TO_WORLD[gravityDirection.method_10146()] = new class_2350[6];
            for (class_2350 direction : class_2350.values()) {
                directionVector = class_243.method_24954((class_2382)direction.method_10163());
                directionVector = RotationUtil.vecPlayerToWorld(directionVector, gravityDirection);
                RotationUtil.DIR_PLAYER_TO_WORLD[gravityDirection.method_10146()][direction.method_10146()] = class_2350.method_10142((double)directionVector.field_1352, (double)directionVector.field_1351, (double)directionVector.field_1350);
            }
        }
        WORLD_ROTATION_QUATERNIONS = new Quaternionf[6];
        RotationUtil.WORLD_ROTATION_QUATERNIONS[0] = new Quaternionf();
        RotationUtil.WORLD_ROTATION_QUATERNIONS[1] = class_7833.field_40718.rotationDegrees(-180.0f);
        RotationUtil.WORLD_ROTATION_QUATERNIONS[2] = class_7833.field_40714.rotationDegrees(-90.0f);
        RotationUtil.WORLD_ROTATION_QUATERNIONS[3] = class_7833.field_40714.rotationDegrees(-90.0f);
        WORLD_ROTATION_QUATERNIONS[3].mul((Quaternionfc)class_7833.field_40716.rotationDegrees(-180.0f));
        RotationUtil.WORLD_ROTATION_QUATERNIONS[4] = class_7833.field_40714.rotationDegrees(-90.0f);
        WORLD_ROTATION_QUATERNIONS[4].mul((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        RotationUtil.WORLD_ROTATION_QUATERNIONS[5] = class_7833.field_40714.rotationDegrees(-90.0f);
        WORLD_ROTATION_QUATERNIONS[5].mul((Quaternionfc)class_7833.field_40716.rotationDegrees(-270.0f));
        ENTITY_ROTATION_QUATERNIONS = new Quaternionf[6];
        for (int i = 0; i < 6; ++i) {
            RotationUtil.ENTITY_ROTATION_QUATERNIONS[i] = new Quaternionf().set((Quaternionfc)WORLD_ROTATION_QUATERNIONS[i]).conjugate();
        }
    }
}

